<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Traits\JsonResponseTrait;
use App\Repositories\Contracts\TransactionRepositoryInterface;
use App\Http\Requests\TransactionRequest;
class TransactionController extends Controller
{
  use JsonResponseTrait;
  protected $transactionRepository;

  function __construct(TransactionRepositoryInterface $transactionRepository)
  {
    if (auth()->check() && auth()->user()->order_type === 'admin') {
      $this->middleware('permission:transaction-list|transaction-create|transaction-edit|transaction-delete', ['only' => ['index', 'show', 'transactionListAll']]);
      $this->middleware('permission:transaction-create', ['only' => ['create', 'order']]);
      $this->middleware('permission:transaction-edit', ['only' => ['edit', 'update', 'changeStatus']]);
      $this->middleware('permission:transaction-delete', ['only' => ['destroy']]);
    }
    $this->transactionRepository = $transactionRepository;
  }
  public function index()
  {
    $customers = cacheRemember('dropdown_transactions_user', 60, function () {
      return DB::table('transactions')
        ->join('users', 'users.id', '=', 'transactions.user_id')
        ->select('users.id', 'users.name')
        ->distinct()
        ->orderBy('users.name')
        ->pluck('users.name', 'users.id');
    }, ['dropdown']);
    return view('admin.transactions.index', [
      'customers' => $customers,
    ]);
  }

  public function transactionListAll(Request $request)
  {
    return $this->transactionRepository->allList($request);
  }

  public function store(TransactionRequest $request)
  {
    $wallet = $this->transactionRepository->store($request, null);
    return $this->successResponse($wallet, __('locale.Transaction Request Created Successfully!'));
  }


}
