<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\JsonResponseTrait;
use App\Repositories\Contracts\ReviewRepositoryInterface;
class ReviewController extends Controller
{
  use JsonResponseTrait;
  protected $reviewRepository;

  function __construct(ReviewRepositoryInterface $reviewRepository)
  {
    if (auth()->check() && auth()->user()->order_type === 'admin') {
      $this->middleware('permission:review-list|review-create|review-edit|review-delete', ['only' => ['index', 'show', 'reviewListAll']]);
      $this->middleware('permission:review-create', ['only' => ['create', 'order']]);
      $this->middleware('permission:review-edit', ['only' => ['edit', 'update', 'changeStatus']]);
      $this->middleware('permission:review-delete', ['only' => ['destroy']]);
    }
    $this->reviewRepository = $reviewRepository;
  }
  public function index()
  {
    $reviewData = $this->reviewRepository->allReview(auth()->id(), 'store');
    return view('store.reviews.index', compact('reviewData'));
  }

  public function reviewListAll(Request $request)
  {
    return $this->reviewRepository->allList($request);
  }



}
