<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Traits\JsonResponseTrait;
use App\Repositories\Contracts\ReferralRepositoryInterface;
use App\Http\Requests\ReferralRequest;
class ReferralController extends Controller
{
  use JsonResponseTrait;
  protected $referralRepository;

  function __construct(ReferralRepositoryInterface $referralRepository)
  {
    if (auth()->check() && auth()->user()->order_type === 'admin') {
      $this->middleware('permission:referral-list|referral-create|referral-edit|referral-delete', ['only' => ['index', 'show', 'referralListAll']]);
      $this->middleware('permission:referral-create', ['only' => ['create', 'order']]);
      $this->middleware('permission:referral-edit', ['only' => ['edit', 'update', 'changeStatus']]);
      $this->middleware('permission:referral-delete', ['only' => ['destroy']]);
    }
    $this->referralRepository = $referralRepository;
  }
  public function index()
  {
    $customers = cacheRemember('dropdown_referrals_user', 60, function () {
      return DB::table('referrals')
        ->join('users', 'users.id', '=', 'referrals.user_id')
        ->select('users.id', 'users.name')
        ->distinct()
        ->orderBy('users.name')
        ->pluck('users.name', 'users.id');
    }, ['dropdown']);
    return view('admin.referrals.index', compact('customers'));
  }

  public function referralListAll(Request $request)
  {
    return $this->referralRepository->allList($request);
  }

  public function store(ReferralRequest $request)
  {
    $wallet = $this->referralRepository->store($request, null);
    return $this->successResponse($wallet, __('locale.Referral Earning saved successfully!'));
  }


}
