<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Http\Requests\ParcelCategoryRequest;
use App\Repositories\Contracts\ParcelCategoryRepositoryInterface;
use App\Traits\JsonResponseTrait;
use App\Traits\ImageUploadTrait;
class ParcelCategoryController extends Controller
{
  use JsonResponseTrait, ImageUploadTrait;
  protected $categoryRepository;
  public function __construct(ParcelCategoryRepositoryInterface $categoryRepository)
  {
    $this->middleware('permission:category-list|category-create|category-edit|category-delete', ['only' => ['index', 'show', 'categoryListAll']]);
    $this->middleware('permission:category-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:category-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:category-delete', ['only' => ['destroy']]);

    $this->categoryRepository = $categoryRepository;
  }

  public function index()
  {
    $allCategories = $this->categoryRepository->allCategories();
    return view('admin.parcel_categories.index', compact('allCategories'));
  }

  public function categoryListAll()
  {
    $categories = $this->categoryRepository->all();
    return \DataTables::of($categories)->addIndexColumn()->make(true);
  }

  public function store(ParcelCategoryRequest $request)
  {
    $data = $request->validated();
    if ($request->hasFile('image')) {
      $data['image'] = $this->uploadImage($request->file('image'), 'categories');
    }
    $category = $this->categoryRepository->store($data);
    return $this->successResponse($category, __('locale.Parcel Type Uploaded Successfully'));
  }

  public function update(ParcelCategoryRequest $request, $id)
  {
    $category = $this->categoryRepository->update($id, $request->validated());
    if ($request->hasFile('image')) {
      $path = $this->uploadImage($request->file('image'), 'categories', $category->image);
      $category->image = $path;
      $category->save();
    }
    return $this->successResponse($category->load('parent'), __('locale.Parcel Type Edited Successfully'));
  }

  public function destroy($id)
  {
    $this->categoryRepository->delete($id);
    return $this->successResponse($id, __('locale.Parcel Type Deleted Successfully'));
  }

  public function changeStatus()
  {
    $category = $this->categoryRepository->toggleStatus(request('id'), request('status'));
    return $this->successResponse($category, __('locale.Parcel Type Status Changes Successfully'));
  }
  public function subcategories($id)
  {
    return $this->categoryRepository->subCategories($id);
  }

}
