<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Http\Requests\FaqRequest;
use App\Repositories\Contracts\FaqRepositoryInterface;
use App\Traits\JsonResponseTrait;

class FaqController extends Controller
{
  use JsonResponseTrait;

  protected $faqRepository;

  public function __construct(FaqRepositoryInterface $faqRepository)
  {
    $this->middleware('permission:data-list|data-create|data-edit|data-delete', ['only' => ['index', 'show', 'faqListAll']]);
    $this->middleware('permission:data-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:data-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:data-delete', ['only' => ['destroy']]);

    $this->faqRepository = $faqRepository;
  }

  public function index()
  {
    return view('common.faqs');
  }

  public function faqListAll()
  {
    $faqs = $this->faqRepository->all();
    return \DataTables::of($faqs)
      ->addIndexColumn()
      ->addColumn('delete_url', function ($item) {
        return url('admin/faqs/' . $item->id);
      })
      ->addColumn('status_url', function ($item) {
        return url('admin/faqs/changestatus');
      })
      ->make(true);
  }

  public function store(FaqRequest $request)
  {
    $faq = $this->faqRepository->store($request->validated());
    return $this->successResponse($faq, __('locale.Faq Uploaded Successfully'));
  }

  public function update(FaqRequest $request, $id)
  {
    $faq = $this->faqRepository->update($id, $request->validated());
    return $this->successResponse($faq, __('locale.Faq Edited Successfully'));
  }

  public function destroy($id)
  {
    $this->faqRepository->delete($id);
    return $this->successResponse($id, __('locale.Faq Deleted Successfully'));
  }

  public function changeStatus()
  {
    $faq = $this->faqRepository->toggleStatus(request('id'), request('status'));
    return $this->successResponse($faq, __('locale.Faq Status Changes Successfully'));
  }
}
