<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Email;
use App\Http\Requests\StoreEmailRequest;
use Auth;
use App\Helpers\Helpers;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Mail;
use App\Mail\PromotionEmail;
use App\Traits\JsonResponseTrait;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
class EmailAppController extends Controller
{
  use JsonResponseTrait;
  function __construct()
  {
    $this->middleware('permission:notification-list|notification-create|notification-edit|notification-delete', ['only' => ['emailApp', 'getUsers', 'listEmail']]);
    $this->middleware('permission:notification-create', ['only' => ['sendEmail', 'store']]);
    $this->middleware('permission:notification-edit', ['only' => ['edit', 'update', 'changeStatus', 'toggleBookmark']]);
    $this->middleware('permission:notification-delete', ['only' => ['destroy']]);
  }
  // Email App
  public function index($type = null)
  {
    $emails = Email::orderBy('id', 'Desc')->Limit(100)->get();
    $roles = Role::orderBy('id', 'DESC')->get();
    return view('/common/app-email')->with(compact('emails', 'roles'));
  }


  public function getUsers($role)
  {
    $cat = array();
    $roll = Role::where('name', $role)->first();
    $role = empty($roll) ? 'User' : $role;
    if ($role == 'User') {
      $data = User::where('user_type', $role)->where('status', '1')->get();
    } else {
      $data = User::role($roll)->where('status', '1')->get();
    }

    foreach ($data as $key => $value) {
      $idd = empty($value['id']) ? $value['phone'] : $value['id'];
      if (empty($idd)) {
        $idd = $value['id'];
      }
      array_push($cat, array('id' => $value['id'], 'value' => $idd, 'label' => $value['name'] . '(' . $idd . ')'));
    }
    return $cat;
  }

  public function sendEmail(StoreEmailRequest $request)
  {
    $emails = User::whereIn('id', $request->emails)->pluck('email');
    $em = new Email;
    $em->subject = $request->subject;
    $em->body = $request->message;
    $em->send_to = json_encode($emails);
    $em->type = $request->type;
    if (!empty($request->file('icon'))) {
      $manager = new ImageManager(new Driver());
      $image = $request->file('icon');
      $imagename = 'NT-' . time() . '.' . $image->extension();
      $destinationPath = public_path('storage/Files/');
      $manager->read($image)->save($destinationPath . $imagename);
      $em->icon = $imagename;
    }
    $em->message_type = $request->message_type;
    $em->user_id = Auth::guard('web')->id();
    $em->status = 'Enable';
    $em->save();
    // send data to emails details;
    //print_r($em->send_to);die;
    $emails_id = json_decode($em->send_to);

    foreach ($emails_id as $key => $email) {
      $row = User::where('id', $email)->orWhere('phone', $email)->orWhere('email', $email)->first();

      \DB::table('email_details')->insert([
        'user_id' => $row->id ?? 0,
        'email_id' => $em->id,
        'seen' => 0
      ]);

    }

    if ($request->message_type == 'Email') {
      //emails
      $emails = User::whereIn('id', $request->emails)->whereNotNull('email')->pluck('email')->toArray();
      $data['body'] = $request->message;
      $data['subject'] = $request->subject;
      $data['address'] = '';
      $url = url('/');
      $data['logo'] = $url . "assets/img/branding/logo.png";

      $to_email = Auth::guard('web')->user()->email;

      Mail::to($to_email)->bcc($emails)->send(new PromotionEmail($data));
    } else {
      $tokens = User::whereIn('id', $request->emails)->whereNotNull('fcm_token')->pluck('fcm_token')->toArray();
      $title = $request->subject;
      $message = strip_tags($request->message);
      if (count($tokens) > 0) {
        $image = !empty($em->icon) ? url('storage/Files') . '/' . $em->icon : '';
        $fcm = Helpers::fcm_notifications($title, $message, $tokens, ['type' => 'emails', 'type_id' => $em?->id], $image);
      }
    }
    $result['message'] = __('locale.Message Sent Successfully');
    $result['code'] = 200;
    return $result;

  }
  public function changeStatus(Request $request, $status)
  {
    $ids = $request->input('ids');
    Email::whereIn('id', $ids)->update(['status' => $status]);
    return $this->successResponse(null, __('locale.Status changes successfully.'));
  }

  public function toggleBookmark(Request $request)
  {
    $id = $request->input('id');
    $status = $request->input('status'); // 'Starred' or 'Enable'
    if (!$id || !in_array($status, ['Starred', 'Enable'])) {
      return $this->errorResponse(__('locale.Invalid request'), 400, null);
    }

    $email = Email::find($id);
    if (!$email) {
      return $this->errorResponse(__('locale.Email not found'), 404, null);
    }
    $email->status = $status;
    $email->save();
    return $this->successResponse(null, __('locale.Status changes successfully.'));
  }


  public function destroy(Request $request)
  {
    $ids = $request->input('ids');
    Email::whereIn('id', $ids)->update(['status' => 'Deleted']);
    return $this->successResponse(null, __('locale.Message Move to Trash Successfully.' . implode(',', $ids)));
  }
}
