<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Http\Requests\DeliveryChargeRequest;
use App\Repositories\Contracts\DeliveryChargeRepositoryInterface;
use App\Traits\JsonResponseTrait;
use App\Models\Country;
use Illuminate\Http\Request;

class DeliveryChargeController extends Controller
{
  use JsonResponseTrait;

  protected $deliveryChargeRepository;

  public function __construct(DeliveryChargeRepositoryInterface $deliveryChargeRepository)
  {
    $this->middleware('permission:site_Settings-list|site_Settings-create|site_Settings-edit|site_Settings-delete', ['only' => ['index', 'show']]);
    $this->middleware('permission:site_Settings-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:site_Settings-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:site_Settings-delete', ['only' => ['destroy']]);

    $this->deliveryChargeRepository = $deliveryChargeRepository;
  }

  public function index(Request $request)
  {
    $countries = Country::where('status', 1)->get();
    $country = $request->query('country');
    $charges = [];
    if (!empty($country)) {
      $charges = $this->deliveryChargeRepository->getDeliveryCharges($country);
    }
    return view('admin.delivery_charges.index', compact('countries', 'charges', 'country'));
  }

  public function store(DeliveryChargeRequest $request)
  {
    $delivery = $this->deliveryChargeRepository->store($request);
    return $this->successResponse($delivery, __('locale.Delivery charges updated successfully!'));
  }

  public function destroy($id)
  {
    $this->deliveryChargeRepository->delete($id);
    return $this->successResponse($id, __('locale.Delivery Charge Deleted Successfully'));
  }

}
