<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Traits\JsonResponseTrait;
use App\Http\Requests\CountryRequest;
use App\Models\Country;
use Illuminate\Support\Facades\DB;
use App\Helpers\Helpers;
class CountryController extends Controller
{
  use JsonResponseTrait;
  public function __construct()
  {
    $this->middleware('permission:site_Settings-list|site_Settings-create|site_Settings-edit|site_Settings-delete', ['only' => ['index', 'show', 'listAll']]);
    $this->middleware('permission:site_Settings-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:site_Settings-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:site_Settings-delete', ['only' => ['destroy']]);

  }

  public function index()
  {
    $currency = cache()->remember('currency_symbol', 3600, fn() => Helpers::setting('currency_symbol', 'currency'));
    return view('admin.countries.index', compact('currency'));
  }

  public function listAll()
  {
    $countries = Country::orderBy('name')->get();
    $currency = cache()->remember('currency_symbol', 3600, fn() => Helpers::setting('currency_symbol', 'currency'));
    return \DataTables::of($countries)->addIndexColumn()->with(['currency' => $currency])->make(true);
  }

  public function update(CountryRequest $request, $id)
  {
    $country = Country::findOrFail($id);
    $country->update($request->validated());
    return $this->successResponse($country, __('locale.Edit Country Base Price Successfully'));
  }

  public function changeStatus()
  {
    $country = Country::findOrFail(request('id'));
    $country->status = request('status') == 1 ? 0 : 1;
    $country->save();
    return $this->successResponse($country, __('locale.Country Status Changes Successfully'));
  }

  public function countries()
  {
    $countries = Country::select('id', 'name', 'sortname')->where('status', 1)->orderBy('name')->get();
    return response()->json($countries);
  }

  public function states($countryId)
  {
    $states = DB::table('states')->where('country_id', $countryId)->select('id', 'name')->orderBy('name')->get();
    return response()->json($states);
  }

  public function cities($stateId)
  {
    $cities = DB::table('cities')->where('state_id', $stateId)->select('id', 'name')->orderBy('name')->get();
    return response()->json($cities);
  }

  public function colorDropdown()
  {
    $colors = DB::table('colors')->select('id', 'name', 'code')->orderBy('name')->get();
    return response()->json($colors);
  }

}
