<?Php
namespace App\Http\Controllers\admin;
use App\Repositories\Contracts\ContactRepositoryInterface;
use App\Http\Controllers\Controller;
use App\Traits\JsonResponseTrait;
use App\Helpers\Helpers;
use Illuminate\Http\Request;
use App\Http\Requests\UpdateTicketRequest;
class ContactController extends Controller
{

  use JsonResponseTrait;
  protected $contactRepository;
  public function __construct(ContactRepositoryInterface $contactRepository)
  {
    $this->middleware('permission:ticket-list|ticket-create|ticket-edit|ticket-delete', ['only' => ['index', 'show', 'ticketListAll']]);
    $this->middleware('permission:ticket-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:ticket-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:ticket-delete', ['only' => ['destroy']]);
    $this->contactRepository = $contactRepository;
  }

  public function index()
  {
    Helpers::markNotificationsAsRead('Support Tickets');
    $ticket = $this->contactRepository->all();
    return view('common.tickets', compact('ticket'));
  }

  public function ticketListAll()
  {
    $result = $this->contactRepository->getTicketListWithStats();
    $data = $result['data'];
    $stats = $result['stats'];
    return \DataTables::of($data)->addIndexColumn()->with($stats)->make(true);
  }

  public function update(UpdateTicketRequest $request, $id)
  {
    $ticket = $this->contactRepository->updateTicketMessage($id, $request->message);
    return $this->successResponse($ticket, __('locale.Admin message added Successfully'));
  }

  public function destroy($id)
  {
    $this->contactRepository->delete($id);
    return $this->successResponse($id, __('locale.Ticket Deleted Successfully'));
  }

  public function changeStatus(Request $request)
  {
    $ticket = $this->contactRepository->changeTicketStatus($request);
    return $this->successResponse($ticket->id, __('locale.Ticket has been closed successfully'));
  }
}
