<?php
namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponseTrait;
use App\Http\Requests\OrderRequest;
use Illuminate\Http\Request;
use App\Http\Requests\ReviewRequest;
use App\Http\Resources\OrderCollection;
use App\Http\Resources\OrderResource;
use App\Repositories\Contracts\ReviewRepositoryInterface;
use App\Repositories\Contracts\OrderRepositoryInterface;
use Spatie\Browsershot\Browsershot;
class OrderController extends Controller
{
  use ApiResponseTrait;
  protected $orderRepository, $reviewRepository;
  public function __construct(OrderRepositoryInterface $orderRepository, ReviewRepositoryInterface $reviewRepository)
  {
    $this->orderRepository = $orderRepository;
    $this->reviewRepository = $reviewRepository;
  }
  public function placeOrder(OrderRequest $request)
  {
    $order = $this->orderRepository->store($request, null);
    return $this->successResponse($order, __('locale.Order Created Successfully!'));
  }

  public function orderHistory(Request $request)
  {
    $orders = $this->orderRepository->orderHistory($request);
    $collection = new OrderCollection($orders);
    $fullArray = $collection->response()->getData(true);
    return $this->successResponse(['data' => $fullArray['data'], 'links' => $fullArray['links'], 'meta' => $fullArray['meta']], __('locale.Data fetched successfully'));
  }
  public function orderDetail(Request $request, $id)
  {
    $order = $this->orderRepository->orderDetail($request, $id);
    return new OrderResource($order);
  }
  public function getOrderFeedback($orderId)
  {
    $data = $this->orderRepository->orderFeedback($orderId);
    return $this->successResponse($data, '', 200);
  }
  public function orderFeedback(ReviewRequest $request, $orderId)
  {
    $data = $this->reviewRepository->store($request, $orderId, 'Order');
    return $this->successResponse($data['order_review'] ?? [], $data['message'] ?? '', 200);
  }

  public function downloadOrderInvoice($orderId)
  {
    $data = $this->orderRepository->findAll($orderId, []);
    $order = $data['order'];
    $html = view('store.orders.pdf_invoice', compact('order'))->render();

    // Generate PDF using Browsershot (headless Chrome)
    $pdf = Browsershot::html($html)
      ->setPaper('a4')
      ->margins(10, 10, 10, 10)
      ->waitUntilNetworkIdle() // ensures all CSS/JS loaded
      ->showBackground()       // renders background colors
      ->pdf();                 // generates PDF content

    $fileName = 'invoice-' . $order->order_id . '.pdf';

    // Return PDF download
    return response($pdf, 200)
      ->header('Content-Type', 'application/pdf')
      ->header('Content-Disposition', 'inline; filename="' . $fileName . '"');
  }

}
