<?php
namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Hash;
use App\Traits\ApiResponseTrait;

class ForgotPasswordController extends Controller
{
  use ApiResponseTrait;
  // Send reset link
  public function sendResetLink(Request $request)
  {
    $request->validate([
      'email' => 'required|email|exists:users,email',
    ]);
    $status = Password::sendResetLink($request->only('email'));
    if ($status === Password::RESET_LINK_SENT) {
      return $this->successResponse([], __('locale.Reset link sent to your email'), 200);
    }
    return $this->errorResponse([], __('locale.Unable to send reset link'), 400);
  }

  // Reset password
  public function resetPassword(Request $request)
  {
    $request->validate([
      'email' => 'required|email|exists:users,email',
      'token' => 'required|string',
      'password' => 'required|string|confirmed|min:6',
    ]);
    $status = Password::reset(
      $request->only('email', 'password', 'password_confirmation', 'token'),
      function ($user, $password) {
        $user->password = Hash::make($password);
        $user->save();
      }
    );
    if ($status === Password::PASSWORD_RESET) {
      return $this->successResponse([], __('locale.Password reset successfully'), 200);
    }
    return $this->errorResponse([], __('locale.Invalid token or email'), 400);
  }
}
