<?php
namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Http\Requests\DriverRequest;
use App\Http\Resources\DriverCollection;
use App\Repositories\Contracts\DriverRepositoryInterface;
use App\Traits\ApiResponseTrait;
use App\Services\CouponService;
use App\Http\Resources\UserProfileResource;
use Illuminate\Support\Facades\Log;
class DriverController extends Controller
{
  use ApiResponseTrait;
  protected $driverRepository;
  protected $couponService;
  function __construct(DriverRepositoryInterface $driverRepository, CouponService $couponService)
  {
    $this->driverRepository = $driverRepository;
    $this->couponService = $couponService;
  }
  public function getDrivers(Request $request)
  {
    $latitude = $request->latitude;
    $longitude = $request->longitude;
    $type = $request->type ?? null; //Ride||Delivery
    $vehicleCategoryId = $request->vehicle_category_id ?? null;
    $drivers = $this->driverRepository->getNearestDrivers($latitude, $longitude, 50, $type, $vehicleCategoryId);
    return new DriverCollection($drivers);
  }
  public function getVehicleTypes(Request $request)
  {
    $vehicles = $this->driverRepository->getVehicleTypes($request);
    return $this->successResponse($vehicles ?? [], '', 200);
  }

  public function applyCoupon(Request $request)
  {
    $data = $this->couponService->applyCoupon($request);
    return $data;
  }

  public function removeCoupon(Request $request)
  {
    $data = $this->couponService->removeCoupon($request);
    return $data;
  }

  public function register(DriverRequest $request)
  {
    $driver = $this->driverRepository->find(auth()->id());
    $this->driverRepository->register($request, $driver->id);
    $collection = new UserProfileResource(User::find(auth()->id()));
    $fullArray = $collection->response()->getData(true);
    return $this->successResponse($fullArray['data'], __('locale.Driver Updated Successfully!'), 200);
  }

  public function activeStatus(Request $request)
  {
    $driver = $this->driverRepository->toggleActiveStatus();
    //Log::info('status toggle from: ' . $driver->is_active);
    $data['is_active'] = $driver->is_active == 1 ? true : false;
    return $this->successResponse($data, __('locale.Driver Status Changed Successfully'));
  }

}
