<?php

namespace App\Events;

use App\Models\RideTemp;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class RideExpiredEvent implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $rideTemp;

  public function __construct(RideTemp $rideTemp)
  {
    $this->rideTemp = $rideTemp;
  }

  public function broadcastOn()
  {
    return new PrivateChannel('user.' . $this->rideTemp->user_id);
  }
  public function broadcastAs(): string
  {
    return 'ride.expired';
  }


  public function broadcastWith()
  {
    return [
      'ride_temp_id' => $this->rideTemp->id,
      'status' => 'Expired',
      'message' => __('locale.No drivers accepted the ride request.'),
    ];
  }
}


/* Echo.private(`user.${userId}`)
  .listen('RideExpiredEvent', (e) => {
    console.log('Ride Expired:', e.message);
    // show alert to user, allow retry, etc.
  }); */
