<?php

namespace App\Events;

use App\Models\Ride;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class RideEndEvent implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $ride;

  public function __construct(Ride $ride)
  {
    $this->ride = $ride;
  }

  public function broadcastOn()
  {
    return new PrivateChannel('user.' . $this->ride->user_id);
  }
  public function broadcastAs(): string
  {
    return 'ride.end';
  }


  public function broadcastWith()
  {
    return [
      'ride_id' => $this->ride->id,
      'status' => 'Ride End',
      'message' => __('locale.Driver has ended the ride. Invoice generated for payment.'),
    ];
  }
}


/* Echo.private(`user.${userId}`)
  .listen('RideExpiredEvent', (e) => {
    console.log('Ride Expired:', e.message);
    // show alert to user, allow retry, etc.
  }); */
