<?php

namespace App\Events;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use App\Models\Ride;
class RideAcceptedEvent implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $ride;

  public function __construct(Ride $ride)
  {
    $this->ride = $ride;
  }

  /**
   * Get the channels the event should broadcast on.
   *
   * @return Channel|array
   */

  public function broadcastOn()
  {
    return new PrivateChannel('user.' . $this->ride->user_id);
  }
  public function broadcastAs(): string
  {
    return 'ride.accept';
  }


  public function broadcastWith()
  {
    return [
      'ride_id' => $this->ride->id,
      'type' => $this->ride->type,
      'status' => 'Accepted',
      'driver_id' => $this->ride->driver_id
    ];

  }

}

/* Echo.private(`user.${userId}`)
  .listen('RideAcceptedEvent', (e) => {
    console.log('Ride Expired:', e.message);
    // show alert to user, allow retry, etc.
  }); */
