<?php

namespace App\Events;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class NewChatMessage implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $payload;
  public $receiverIds;

  /**
   * Create a new event instance.
   */
  public function __construct(array $payload, array $receiverIds)
  {
    $this->payload = $payload;
    $this->receiverIds = $receiverIds;
  }

  /**
   * Channels to broadcast on
   */
  public function broadcastOn(): array
  {
    return collect($this->receiverIds)
      ->map(fn($id) => new PrivateChannel("chat.user.{$id}"))
      ->toArray();
  }

  public function broadcastAs(): string
  {
    return 'new.chat.message';
  }

  public function broadcastWith(): array
  {
    //Log::info('NewChatMessage payload being sent', $this->payload);
    return $this->payload;
  }
}
