<?php
namespace App\Events;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class DriverLocationUpdatedEvent implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $driverId, $lat, $lng, $rideId;

  public function __construct($driverId, $lat, $lng, $rideId)
  {
    $this->driverId = $driverId;
    $this->lat = $lat;
    $this->lng = $lng;
    $this->rideId = $rideId;
  }

  /**
   * Get the channels the event should broadcast on.
   *
   * @return Channel|array
   */
  public function broadcastOn()
  {
    return new PrivateChannel('ride.' . $this->rideId);
  }

  public function broadcastAs(): string
  {
    return 'driver.location';
  }

  public function broadcastWith()
  {
    return [
      'driver_id' => $this->driverId,
      'lat' => $this->lat,
      'lng' => $this->lng,
      'ride_id' => $this->rideId,
      'updated_at' => now(),
    ];
  }
}
