<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Carbon\Carbon;

class DeleteOrphanedImages extends Command
{
  protected $signature = 'images:cleanup';
  protected $description = 'Delete images that have no record in the database';

  public function __construct()
  {
    parent::__construct();
  }

  public function handle()
  {
    // Define directory and query pairs
    $cleanupConfigs = [
      [
        'directories' => [
          //public_path('storage/Banner/thumbnail/'),
          public_path('storage/')
        ],
        'imageRecords' => DB::table('banners')->pluck('image')->toArray()
      ],
      [
        'directories' => [
          public_path('storage/')
        ],
        'imageRecords' => DB::table('categories')->whereNull('deleted_at')->pluck('image')->toArray()
      ],
      [
        'directories' => [
          public_path('storage/')
        ],
        'imageRecords' => DB::table('parcel_categories')->whereNull('deleted_at')->pluck('image')->toArray()
      ],
      [
        'directories' => [
          public_path('storage/')
        ],
        'imageRecords' => DB::table('product_images')->pluck('file')->toArray()
      ],
      [
        'directories' => [
          public_path('storage/')
        ],
        'imageRecords' => array_merge(
          DB::table('users')->where('user_type', 'Store')->whereNull('deleted_at')->pluck('profile_photo_path')->toArray(),
          DB::table('users')->where('user_type', 'Driver')->whereNull('deleted_at')->pluck('profile_photo_path')->toArray(),
          DB::table('users')->where('user_type', 'User')->whereNull('deleted_at')->pluck('profile_photo_path')->toArray()
        )
      ],
      [
        'directories' => [
          public_path('storage/')
        ],
        'imageRecords' => array_merge(
          DB::table('vehicles')->whereNull('deleted_at')->pluck('vehicle_image')->toArray(),
          DB::table('vehicles')->whereNull('deleted_at')->pluck('insurance_image')->toArray(),
          DB::table('vehicles')->whereNull('deleted_at')->pluck('road_worthiness_image')->toArray(),
          DB::table('vehicles')->whereNull('deleted_at')->pluck('vehicle_registration_image')->toArray()
        )
      ],
      [
        'directories' => [
          public_path('storage/Files/')
        ],
        'imageRecords' => DB::table('emails')->pluck('icon')->toArray()
      ],


    ];

    foreach ($cleanupConfigs as $config) {
      $this->cleanupDirectory($config['directories'], $config['imageRecords']);
    }

    $this->info('Cleanup completed.');
  }

  private function cleanupDirectory(array $directories, array $imageRecords)
  {
    foreach ($directories as $directory) {
      if (File::exists($directory)) {
        $files = File::files($directory);

        foreach ($files as $file) {
          $filename = $file->getFilename();

          // Check if the file exists in the database records
          if (!in_array($filename, $imageRecords)) {
            // Delete the file if it doesn't exist in the database
            File::delete($file->getRealPath());
            $this->info("Deleted: $filename");

          }
        }
      } else {
        $this->error("Directory not found: $directory");
      }
    }
  }
}
