<?php

use App\Models\AdminNotificationModel;
use App\Models\NotificationModel;
use libphonenumber\NumberParseException;
use libphonenumber\PhoneNumberUtil;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Arr;
use PHPUnit\Framework\Constraint\FileExists;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth as CustomerAuth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\DealModel;
use App\Models\CustomerModel;
use App\Models\CustomerRankModel;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;


define('ACTIVE', 'active');
define('INACTIVE', 'inactive');
define('CUSTOMER_PATH', 'uploads/customers');
define('ADMIN_PATH', 'uploads/admin');
define('DISPUTED_DOCS_PATH', 'uploads/dispute_docs');
define('PAYMENT_PROOF_PATH', 'uploads/payment_proofs');
define('SHIPPING_PROOF_PATH', 'uploads/shipping_proofs');
define('BANNER_PATH', 'uploads/admin/banners');
define('DEAL_IMAGES', 'uploads/deal_images');
define('DISPLAY_DATE', 'd-m-Y');
define('DISPLAY_TIME', 'H:i:s');
define('DISPLAY_DATETIME', 'd-m-Y h:i A');
define('CURRENCY', '$');
//deal status constants
define('PENDING', 'pending');
define('DECLINED', 'declined');
define('ACCEPTED', 'accepted');
define('REJECTED', 'rejected');
define('TRANSIT', 'shipped');
define('DELIVERED', 'delivered');
define('COMPLETED', 'completed');
define('CANCEL', 'cancel');
define('CANCELLED', 'cancelled');
define('ON DISPUTE', 'on dispute');
define('CLOSED', 'closed');
define('ONGOING', 'ongoing');
define('DISPUTED', 'disputed');
define('HOLD_AMOUNT', 'hold-amount');
define('ON_DISPUTE', 'on_dispute');
define('DISPUTE_UNDER_REVIEW', 'dispute_under_review');
define('DISPUTE_ACCEPTED', 'dispute_accepted');
define('DISPUTE_REJECTED', 'dispute_rejected');
define('PAID', 'paid');
define('BUY', 'buy');
define('SELL', 'sell');
define('USER_DEFAULT_IMG_PATH', 'admin-assets/img/default.png');
define('USER_UPLOADED_IMG_PATH', 'uploads/customers/');
define('RANK_ICONS', 'admin-assets/img/');
//logo
define('LOGO_IMG_PATH', 'admin-assets/img/logo.png');
define('SELL_COLOR', '4472c3');
define('BUY_COLOR', 'ed7c31');
define('BUYER', 'buyer');
define('SELLER', 'seller');
define('CUSTOMER', 'customer');
define('SUPERADMIN', 'superadmin');
define('ADMIN', 'admin');
define('MONEY_RETURNED_BUYER', 'money_returned_buyer');
define('MONEY_DEPOSITED_SELLER', 'money_deposited_seller');
define('PAYMENT_RECEIVED', 'payment_received');
define('PAYMENT_PENDING', 'payment_pending');
define('INITIAL_COUNTRY', 'MX');
define('DIAL_CODE', '+52');
define('DIAL_CODE_ISO', 'MX');
define('STAR', 'star');
define('MEDAL', 'medal');
define('IMAGE', 'image');
define('ICON', 'icon');
define('USD', 'USD');
define('MXN', 'MXN');

//these notification types i store in notifications table
$notificationTypes = [
    'shipped_item',
    'delivered_item',
    'cancelled_deal',
    'deal_on_dispute',
    'dispute_under_review',
    'dispute_accepted',
    'dispute_rejected',
    'completed_deal',
    'amount_release',
    'Dispute Update',       // keep as is if it is intentionally with space & capitalized
    'payment_approved',
    'deal_request_get',
    'deal_request_action',
    'disputed_deal',
    'reply_by_customer',
    'payment proof',        // keep as is if format is important
    'reply_by_admin',
    'amount_transfer',
    'deal_amount_edit',
    'document_rejected',
    'document_accepted'
];

$disputedStatuses = [
    'on_dispute',
    'dispute_under_review',
    'dispute_accepted',
    'dispute_rejected'
];

//phone validation with dial code and iso
function isValidNumber($dialCode, $dialCodeISO,  $mobileNumber)
{
    $phoneUtil = PhoneNumberUtil::getInstance();
    try {
        $fullMobileNumber = $dialCode . $mobileNumber;
        $swissNumberProto = $phoneUtil->parse($fullMobileNumber, $dialCodeISO);
        $isValid = $phoneUtil->isValidNumber($swissNumberProto);
        if ($isValid) {
            return true;
        }
    } catch (NumberParseException $e) {
        return false;
    }
    return false;
}

//json response
function jsonResponse($status, $statusCode, $message, $extra = [])
{

    $response = [
        'status' => $status,
        'statusCode' => $statusCode,
        'message' => $message,
        'extra' => $extra
    ];

    // if($statusCode == 400) {
    //     unset($response['message']);
    //     $response['errors'] = $message;
    // }

    return response()->json($response, $statusCode);
}
//conversation message response
function jsonResponseForConversation($status, $statusCode)
{

    $response = [
        'status' => $status,
        'statusCode' => $statusCode,
        'convo' => true
    ];

    // if($statusCode == 400) {
    //     unset($response['message']);
    //     $response['errors'] = $message;
    // }

    return response()->json($response, $statusCode);
}

//file upload
function uploadFile($name, $path, $oldFile = '')
{
    $publicPath = env('PUBLIC_BASE_PATH', public_path());
    $fileFullPath = $publicPath . '/' . $path . '/' . $oldFile;
    if ($oldFile && file_exists($fileFullPath)) {
        unlink($fileFullPath);
    }
    $request = request();
    $image = $request->file($name);
    $imageName = uniqid() . '_' . time() . '.' . $image->getClientOriginalExtension();
    //store the image
    $image->move($publicPath . '/' . $path, $imageName);
    return  $imageName;
}

//upload multiple files
function uploadmultifiles($inputFiles, $path)
{
    $publicPath = env('PUBLIC_BASE_PATH', public_path());
    $request = request();
    $uploadedFiles = [];
    foreach ($request->file($inputFiles) as $file) {
        $fileName = uniqid() . '_' . time() . '.' . $file->getClientOriginalExtension();
        $file->move($publicPath . '/' . $path, $fileName);
        $uploadedFiles[] = $fileName;
    }
    return $uploadedFiles;
}

function uploadDefaultImage($path)
{
    $publicPath = env('PUBLIC_BASE_PATH', public_path());
    $defaultImagePath = $publicPath . '/admin-assets/img/default.png';
    $imageName = 'default.png';
    //store the image
    $destinationPath = $publicPath . '/' . $path . '/' . $imageName;
    if (!file_exists($destinationPath)) {
        copy($defaultImagePath, $destinationPath);
    }
    return  $imageName;
}

//per page drop down
function perPage()
{
    return [
        10 => 10,
        20 => 20,
        50 => 50,
        100 => 100,
        500 => 500
    ];
}

//page records information
function pageInfo($pagination)
{
    $from = ((($pagination->currentPage() - 1) * $pagination->perPage()) + 1);
    $to = (($pagination->currentPage()) * $pagination->perPage());
    $total = $pagination->total();
    if ($to > $total) {
        $to = $pagination->total();
    }
    return  __('message.showing') . " <b>{$from}</b> " . __('message.to') . " <b>{$to}</b> " . __('message.of') . " <b>{$total}</b> " . __('message.records') . "";
}

//page indexing
function pageIndex($pagination)
{
    return (($pagination->currentPage() - 1) * $pagination->perPage()) + 1;
}

function StatusText($type)
{
    $types = [
        'inactive' => '<span class="badge bg-label-danger me-1">' . __('message.inactive') . '</span>',
        'active' => '<span class="badge bg-label-success me-1">' . __('message.active') . '</span>',
    ];
    return $types[$type] ?? '--';
}

//display date format
function dateFormat($date, $format, $default = '')
{
    return (!empty($date)) ? date($format, strtotime($date)) : $default;
}

//display satatus to change
function dealStatusSelection(
    $is_title = 0,
    $title = '',
    $is_hold = 0,
    $is_paid = 0,
    $current_status = '',
    $shipping_status = '',
    $shippingProof = ''
) {
    $types = [];
    if ($is_hold == 0 && $is_paid == 0) {
        $types = [
            // 'pending' => 'Pending',
            //'paid' => __('message.paid'),
            'cancel' =>  __('message.cancel')
        ];
    } else {
        switch ($current_status) {
            case 'pending':
                $types = [
                    // 'pending' => 'Pending',
                    'cancel' => __('message.cancel'),
                ];
                break;
            case 'accepted':
                if (
                    $shipping_status == ACCEPTED &&
                    $shippingProof &&
                    is_file(public_path(SHIPPING_PROOF_PATH . '/' . $shippingProof))
                ) {
                    $types = [
                        'shipped' => __('message.shipped'),
                        'cancel' => __('message.cancel')
                    ];
                } else {
                    $types = [
                        'cancel' => __('message.cancel')
                    ];
                }
                break;
            case 'shipped':
                $types = [
                    'delivered' => __('message.delivered'),
                    'on_dispute' => __('message.on_dispute'),
                    'cancel' => __('message.cancel')
                ];
                break;
            case 'delivered':
                $types = [
                    'completed' => __('message.completed'),
                    'on_dispute' => __('message.on_dispute'),

                ];
                break;
            case 'on_dispute':
                $types = [
                    DISPUTE_UNDER_REVIEW => __('message.dispute_under_review'),

                ];
                break;
            case DISPUTE_UNDER_REVIEW:
                $types = [
                    DISPUTE_ACCEPTED => __('message.dispute_accepted'),
                    DISPUTE_REJECTED => __('message.dispute_rejected'),
                ];
        }
    }




    if ($current_status && !array_key_exists($current_status, $types)) {
        $types = [$current_status => str_replace('_', ' ', strtolower($current_status))] + $types;
    }

    return $types;
}

function statusFilter($is_title = 0, $title = '')
{
    $types = [
        'active' => __('message.active'),
        'inactive' => __('message.inactive')

    ];
    $title = empty($title) ? 'Select' : $title;
    if ($is_title) {
        $types = ['' => $title] + $types;
    }

    return $types;
}

function dealStatusFilter($is_title = 0, $title = '')
{
    $types = [
        'pending' => 'Pending',
        'accepted' => 'Accepted',
        'shipped' => 'Shipped',
        'completed' => 'Completed',
        'on_dispute' => 'On Dispute',
        'cancel' => 'Cancel',
        DISPUTE_UNDER_REVIEW => 'Dispute under review',
        DISPUTE_ACCEPTED => 'Dispute accepted',
        DISPUTE_REJECTED => 'Dispute rejected',
    ];
    $title = empty($title) ? 'Select' : $title;
    if ($is_title) {
        $types = ['' => $title] + $types;
    }

    return $types;
}
//when amount is not on hold
function dealStatusFilterNotHold($is_title = 0, $title = '')
{
    $types = [
        'pending' => 'Pending',
        'cancel' => 'Cancel',
    ];
    $title = empty($title) ? 'Select' : $title;
    if ($is_title) {
        $types = ['' => $title] + $types;
    }

    return $types;
}
function dealStatusFilterDispute($is_title = 0, $title = '')
{
    $types = [
        'dispute_accepted' => __('message.dispute_accepted'),
        'dispute_rejected' => __('message.dispute_rejected'),
        'dispute_under_review' => __('message.dispute_under_review'),
        'on_dispute' => __('message.on_dispute'),
    ];
    $title = empty($title) ? 'Select' : $title;
    if ($is_title) {
        $types = ['' => $title] + $types;
    }

    return $types;
}


function ongoingDealStatusFilter($is_title = 0, $title = '')
{
    $types = [
        'pending' => app()->getLocale() == 'en' ? 'Pending' : 'Pendiente',
        'accepted' => app()->getLocale() == 'en' ? 'Accepted' : 'Aceptado',
        'shipped' => app()->getLocale() == 'en' ? 'Shipped' : 'Enviado',
        'completed' => app()->getLocale() == 'en' ? 'Completed' : 'Completado',


    ];
    $title = empty($title) ? 'Select' : $title;
    if ($is_title) {
        $types = ['' => $title] + $types;
    }

    return $types;
}

function dealTypeFilter($is_title = 0, $title = '')
{
    $types = [
        'buy' => app()->getLocale() == 'en' ? 'Buy' : 'Comprar',
        'sell' => app()->getLocale() == 'en' ? 'Sell' : 'Vender',


    ];
    $title = empty($title) ? 'Select' : $title;
    if ($is_title) {
        $types = ['' => $title] + $types;
    }

    return $types;
}



//active check menu
function setActive($routeNames, $output = 'active')
{
    // return Route::currentRouteName() === $routeName ? $output : '';
    return in_array(Route::currentRouteName(), (array) $routeNames) ? $output : '';
}
function readablestatus($dealStatus)
{
    $es_deal_status = null;
    switch ($dealStatus) {
        case PENDING:
            $es_deal_status = 'pendiente';
            break;

        case ACCEPTED:
            $es_deal_status = 'aceptado';
            break;

        case TRANSIT:
            $es_deal_status = 'enviado';
            break;

        case DELIVERED:
            $es_deal_status = 'entregado';
            break;

        case COMPLETED:
            $es_deal_status = 'completado';
            break;

        case CLOSED:
            $es_deal_status = 'cerrado';
            break;

        case CANCEL:
            $es_deal_status = 'cancelar';
            break;

        case ON_DISPUTE:
            $es_deal_status = 'en disputa';
            break;

        case DISPUTE_UNDER_REVIEW:
            $es_deal_status = 'disputa_en_revisión';
            break;

        case DISPUTE_ACCEPTED:
            $es_deal_status = 'disputa_aceptada';
            break;

        case DISPUTE_REJECTED:
            $es_deal_status = 'disputa_rechazada';
            break;
    }

    $dealSts = app()->getLocale() == 'en' ? $dealStatus : $es_deal_status;
    return ucwords(strtolower(str_replace('_', ' ', $dealSts)));
}
//deal status categories
function dealStatusCategories()
{
    return [
        'ongoing' => [PENDING, ACCEPTED, TRANSIT, DELIVERED, COMPLETED],
        'disputed' => [ON_DISPUTE, DISPUTE_ACCEPTED, DISPUTE_REJECTED, DISPUTE_UNDER_REVIEW],
        'cancel' => [CANCEL],
    ];
}
//response through app
function apiResponse($status, $message, $result = [], $errors = false, $messageDescription = '')
{
    if ($errors) {
        $message = Arr::first($message->toArray())[0];
    }
    $response = [
        'status' => (int) $status ?? 0,
        'message' => (string) $message ?? '',
        'message_description' => (string) $messageDescription ?? '',
        'data' => count($result) ? $result : new stdClass()
    ];
    return response()->json($response, $status);
}

function getErrorResponse($e)
{
    $message = $e->getMessage();
    if (str_contains($message, '250/251/252')) {
        return response()->json(['status' => 400, 'message' => 'Email is invalid', 'data' => (new stdClass)], 400);
    }
    if (in_array(env('APP_ENV'), ['local', 'dev'])) {
        return response()->json([
            'status' => false,
            'statusCode' => 500,
            'message' => $e->getMessage(),
            'line' => $e->getLine(),
            'file' => $e->getFile()
        ], 500);
    } else {
        return response()->json([
            'status' => false,
            'statusCode' => 500,
            'message' => 'Internal Server Error'
        ], 500);
    }
}
//get image
function getUserImage($img, $path)
{
    $publicPath = env('PUBLIC_BASE_PATH', public_path());
    $image = asset(USER_DEFAULT_IMG_PATH);
    $file = $publicPath . '/' . $path . '/' . $img;
    if ($img != '' && file_exists($file)) {
        $image = asset($path . $img);
    }
    return $image;
}

//convert app date to database date
function app_date_convert_format($date, $requestedFormat)
{
    return Carbon::createFromFormat($requestedFormat, $date)->format('Y-m-d');
}

//save the notification

function saveNotification($customerId, $type, $title, $titleEs = null, $message, $messageEs = null, $secondPartyId = null, $deal_number = null, $deal_id = null, $is_updation_by_admin = null)
{

    $notification =   NotificationModel::create([
        'customer_id' => $customerId,
        'type' => $type,
        'title' => $title,
        'title_es' => $titleEs,
        'message' => $message,
        'message_es' => $messageEs,
        'second_party_id' => $secondPartyId,
        'deal_number' => $deal_number,
        'deal_id' => $deal_id,
        'is_updation_by_admin' => $is_updation_by_admin
    ]);

    $customer = CustomerModel::find($customerId);
    //find deal data
    $deal = DealModel::find($deal_id);
    if (!$deal || !$customer) {
        //Log::warning("went wrong at notificaion", ['deal' => $deal_id, 'customer' => $customerId]);
        return false;
    }
    $dealType = dealTypeViceVersa($deal, $customer->id);

    $dealTypeLangWise = $dealType === 'Buy' ? __('message.buy') : __('message.sell');


    if ($customer && $customer->fcm_token) {

        // dd($customer->id);
        $lang = $customer->language_code;

        $message = $lang === 'es' ?  $messageEs : $message;
        $title = $lang === 'es' ?  $titleEs : $title;

        $data = [

            'notification_id' => (string)$notification->id,
            'title' => (string)$title,
            'message' => (string)$message,
            'notification_type' => (string)$notification->type,
            'deal_id' => (string)$notification->deal_id,
            'deal_type' => $dealTypeLangWise,

        ];
        fcm_notifications($title, $message, $customer->fcm_token, $data);

        //$fcmId = 'f1q9-Zl1SaylkN1iNQlaM9:APA91bEI_oBZ1kp3B40JEIj1-BZqHrhT8L9ywp710hpwGsOwTAQIrbPySuBKgivaGf_7XE_w68FxmFlLfw1RuHlzy7ongzdMoHY9tUCZ8kul3S3GKputJC8';

        //fcm_notifications($title, $message, $fcmId, $data);
    }
}
function fcm_notifications($title, $message, $token, $data = [], $sound = 'default')
{
    $fcmUrl = 'https://fcm.googleapis.com/v1/projects/saleyvale-a9ff6/messages:send';
    $payload = [
        'message' => [
            'notification' => [
                'title' => $title,
                'body' => str_replace('&nbsp;', ' ', $message),


            ],
            'android' => [
                'notification' => [
                    'sound' => $sound,
                ]
            ],
            'apns' => [
                'payload' => [
                    'aps' => [
                        'sound' => $sound,
                    ],
                ],
            ],
        ],
    ];

    if (!empty($data)) {
        $payload['message']['data'] = $payload['message']['notification'] + $data;
    }

    // Determine if the tokens are an array or a single token
    if (is_array($token)) {
        if (count($token) > 1) {
            $payload['message']['tokens'] = $token; // Use registration_ids for multiple tokens
        } else {
            $payload['message']['token'] = $token[0]; // Single token
        }
    } else {
        $payload['message']['token'] = $token; // Single token
    }

    try {
        //dd($payload);
        $client = new Client();
        $response = $client->post($fcmUrl, [
            'headers' => [
                'Authorization' => 'Bearer ' . getAccessToken(),
                'Content-Type'  => 'application/json',
            ],
            'json' => $payload,
        ]);

        $responseBody = json_decode($response->getBody()->getContents(), true);
        Log::error('FCM Notification sent', ['response' => $responseBody]);

        return $responseBody;
    } catch (\Exception $e) {
        Log::error('FCM Notification Error: ' . $e->getMessage());
        return ['error' => true, 'message' => $e->getMessage()];
    }
}

function getAccessToken()
{
    // Use Google service account credentials to generate access token
    $client = new \Google_Client();
    $client->setAuthConfig(storage_path('firebase-service.json'));
    $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
    $client->useApplicationDefaultCredentials();
    Log::error('FCM Access Token', [
        'token' => $client->fetchAccessTokenWithAssertion()['access_token'],
    ]);
    return $client->fetchAccessTokenWithAssertion()['access_token'];
}

function saveNotificationAdmin($adminId, $dealId, $nTitle, $nMesage, $nMesageEs, $is_read, $nType)
{
    AdminNotificationModel::create([
        'admin_id' => $adminId,
        'deal_id' => $dealId,
        'title' => $nTitle,
        'message' => $nMesage,
        'message_es' => $nMesageEs,
        'is_read' => $is_read,
        'notification_type' => $nType,

    ]);
}

function checkHeaderLang($message_es, $message)
{
    $lang = request()->header('Accept-Language', 'en');
    $message = $lang === 'es' ? $message_es : $message;
    return $message;
}


function getLoggedInCustomerId()
{
    return  CustomerAuth::user()->id;
}
function dealSatusValuesForValidateUpdation()
{
    return [
        TRANSIT,
        COMPLETED,
        DELIVERED,
        CANCEL,
    ];
}
function buyerSellerFields()
{
    return "CASE 
                WHEN deals.deal_type = 'buy' THEN f.full_name 
                ELSE t.full_name 
            END as buyer_name,
            CASE 
                WHEN deals.deal_type = 'sell' THEN f.full_name 
                ELSE t.full_name 
            END as seller_name,
            CASE 
                WHEN deals.deal_type = 'buy' THEN f.email 
                ELSE t.email 
            END as buyer_email,
            CASE 
                WHEN deals.deal_type = 'sell' THEN f.email 
                ELSE t.email 
            END as seller_email,
            CASE 
                WHEN deals.deal_type = 'buy' THEN f.mobile_number 
                ELSE t.mobile_number 
            END as buyer_mobile_number,
            CASE 
                WHEN deals.deal_type = 'sell' THEN f.mobile_number 
                ELSE t.mobile_number 
            END as seller_mobile_number,
            CASE 
                WHEN deals.deal_type = 'buy' THEN f.dial_code 
                ELSE t.dial_code 
            END as buyer_dial_code,
            CASE 
                WHEN deals.deal_type = 'sell' THEN f.dial_code 
                ELSE t.dial_code 
            END as seller_dial_code,
            CASE 
            WHEN deals.deal_type = 'buy' THEN f.deleted_at 
            ELSE t.deleted_at 
        END as buyer_deleted_at,
        CASE 
            WHEN deals.deal_type = 'sell' THEN f.deleted_at 
            ELSE t.deleted_at 
        END as seller_deleted_at";
}
function disputed_status()
{
    return [ON_DISPUTE, DISPUTE_UNDER_REVIEW, DISPUTE_ACCEPTED, DISPUTE_REJECTED];
}
function disputeReasons()
{
    return [
        ['key' => 1, 'value' => __('message.product_not_delivered')],
        ['key' => 2, 'value' => __('message.product_damage')],
        ['key' => 3, 'value' => __('message.not_as_described')],
        ['key' => 4, 'value' => __('message.payment_issue')],
        ['key' => 5, 'value' => __('message.others')],

    ];
}
//dispute status sends with user friendly status
function disputeStatusCustomText($currentDisputeStatus, $dealType)
{
    // Buyer perspective (default)
    $disputeStatuses = [
        ON_DISPUTE  => ['key' => ON_DISPUTE, 'value' => __('message.pending'), 'text_color' => '#ffd045'],
        DISPUTE_UNDER_REVIEW => ['key' => DISPUTE_UNDER_REVIEW, 'value' => __('message.under_review'), 'text_color' => '#ffa014'],
        DISPUTE_ACCEPTED => ['key' => DISPUTE_ACCEPTED, 'value' => __('message.dispute_favor'), 'text_color' => '#78c37b'],
        DISPUTE_REJECTED => ['key' => DISPUTE_REJECTED, 'value' => __('message.dispute_against'), 'text_color' => '#f55145'],
    ];
    $dealType =  strtolower($dealType);
    // Flip status meaning if dealType is SELL (seller perspective)
    if ($dealType == SELL) {

        if ($currentDisputeStatus == DISPUTE_ACCEPTED) {
            // Buyer won => Seller lost
            return ['key' => DISPUTE_REJECTED, 'value' => __('message.dispute_against'), 'text_color' => '#f55145'];
        } elseif ($currentDisputeStatus == DISPUTE_REJECTED) {
            // Buyer lost => Seller won
            return ['key' => DISPUTE_ACCEPTED, 'value' => __('message.dispute_favor'), 'text_color' => '#78c37b'];
        }
    }

    // Return default (same for both sides for ON_DISPUTE and UNDER_REVIEW)
    return $disputeStatuses[$currentDisputeStatus] ?? ['key' => $currentDisputeStatus, 'value' => 'Unknown Status', 'text_color' => '#999999'];
}
function disputeAmountTransfer($currentDisputeStatus, $customerType)
{

    $customerType =  strtolower($customerType);

    $key = 'dispute_amount_transefered';
    switch ($currentDisputeStatus) {
        case DISPUTE_ACCEPTED:
            if ($customerType == BUYER) {

                return ['key' => $key, 'value' => __('message.transfer_to_you')];
            } elseif ($customerType == SELLER) {

                return ['key' => $key, 'value' => __('message.transferred_to_buyer')];
            }
            break;
        case DISPUTE_REJECTED:
            if ($customerType == BUYER) {

                return ['key' => $key, 'value' => __('message.transferred_to_seller')];
            } elseif ($customerType == SELLER) {

                return ['key' => $key, 'value' =>  __('message.transfer_to_you')];
            }
            break;
    }
    return ['key' => null, 'value' => 'null'];
}
//get customer type
function getCustomerType($deal, $customerId)
{
    if ($deal->deal_type == BUY) {
        // return ($deal->from_customer_id == $customerId) ? BUYER : SELLER;
        return ($deal->from_customer_id == $customerId) ? [__('message.buyer'), BUYER] : [__('message.seller'), SELLER];
    } elseif ($deal->deal_type == SELL) {
        //return ($deal->from_customer_id == $customerId) ?  SELLER : BUYER;
        return ($deal->from_customer_id == $customerId) ?  [__('message.seller'), SELLER] : [__('message.buyer'), BUYER];
    }
    return [__('message.unknown', null)];
}
// custom status of payment
function paymentStatusCustomText($deal, $releasedTo)
{
    $paymentStatus = [];
    if (
        $deal->is_paid == 1
        && $deal->is_release == 1 && !empty($deal->amount_released_to)
    ) {

        [$customerLabel, $customerType] =  getCustomerType($deal, $releasedTo);
        if ($customerType == BUYER) {
            $paymentStatus = ['key' => MONEY_RETURNED_BUYER, 'value' => __('message.money_returned_buyer')];
        } elseif ($customerType == SELLER) {
            $paymentStatus = ['key' => MONEY_DEPOSITED_SELLER, 'value' => __('message.money_deposited_seller')];
        }
    } elseif ($deal->is_paid == 1 && $deal->is_hold == 1 && $deal->is_release == 0) {
        $paymentStatus = ['key' => PAYMENT_RECEIVED, 'value' => __('message.payment_received')];
    } elseif ($deal->is_paid == 0 && $deal->is_hold == 0 && $deal->is_release == 0) {
        $paymentStatus = ['key' => PAYMENT_PENDING, 'value' => __('message.payment_pending')];
    }
    return $paymentStatus;
}
//money deposited status
function moneyDepositedStatus($deal, $releasedTo)
{
    $payment_status_data = paymentStatusCustomText($deal, $releasedTo);
    if (empty($payment_status_data)) {
        dd($deal->toArray(), $releasedTo, $payment_status_data);
    }


    // dd($payment_status_data['value']);
    $payment_status = $payment_status_data['value'];
    //dd($payment_status);
    if (
        $deal->is_paid == 1
        && $deal->is_release == 1 && !empty($deal->amount_released_to)
    ) {

        [$customerLabel, $customerType] =  getCustomerType($deal, $releasedTo);
        if ($customerType == BUYER) {
            return ['payment_status' => $payment_status, 'color' => BUY_COLOR, 'icon' => 'bxs-check-circle'];
        } elseif ($customerType == SELLER) {
            return ['payment_status' => $payment_status, 'color' =>  SELL_COLOR, 'icon' => 'bxs-check-circle'];
        }
    } elseif ($deal->is_paid == 1 && $deal->is_hold == 1 && $deal->is_release == 0) {
        return ['payment_status' => $payment_status, 'color' => '3ac422', 'icon' => 'bxs-check-circle'];
    } elseif ($deal->is_paid == 0 && $deal->is_hold == 0 && $deal->is_release == 0) {
        return ['payment_status' => $payment_status, 'color' => 'ec4b35', 'icon' => 'bxs-error-circle'];
    } else {
        //dd($deal, $releasedTo);
    }
}
function getDealstatusWithColor($deal_status)
{
    $types = [
        PENDING => ['label' => __('message.pending'), 'class' => 'bg-warning text-dark'],
        ACCEPTED => ['label' => __('message.accepted'), 'class' => 'bg-info text-dark'],
        TRANSIT => ['label' => __('message.shipped'), 'class' => 'bg-primary'],
        DELIVERED => ['label' => __('message.delivered'), 'class' => 'bg-dark'],
        COMPLETED => ['label' => __('message.completed'), 'class' => 'bg-success'],
        ON_DISPUTE => ['label' => __('message.on_dispute'), 'class' => 'bg-danger'],
        DISPUTE_ACCEPTED => ['label' => __('message.dispute_accepted'), 'class' => 'bg-success'],
        DISPUTE_REJECTED => ['label' => __('message.dispute_rejected'), 'class' => 'bg-danger'],
        DISPUTE_UNDER_REVIEW => ['label' => __('message.dispute_under_review'), 'class' => 'bg-danger'],
        CANCEL => ['label' => __('message.cancel'), 'class' => 'bg-danger'],
        CLOSED => ['label' => __('message.closed'), 'class' => 'bg-secondary'],
    ];
    if (!isset($types[$deal_status])) {
        return '<span class="badge bg-dark">' . __('message.unknown') . '</span>';
    }
    return '<span class="badge ' . $types[$deal_status]['class'] . '" >' . $types[$deal_status]['label'] . '</span>';
}
//display status histry wise
function displayStatusHistory($dealHistoryStatus)
{
    $statusMapping = [
        PENDING => ['key' => PENDING, 'value' => __('message.pending')],
        ACCEPTED => ['key' => ACCEPTED, 'value' => __('message.accepted')],
        TRANSIT => ['key' => TRANSIT, 'value' => __('message.shipped')],
        DELIVERED => ['key' => DELIVERED, 'value' => __('message.delivered')],
        COMPLETED => ['key' => COMPLETED, 'value' => __('message.completed')],
        ON_DISPUTE => ['key' => ON_DISPUTE, 'value' => __('message.on_dispute')],
        DISPUTE_ACCEPTED => ['key' => DISPUTE_ACCEPTED, 'value' => __('message.dispute_accepted')],
        DISPUTE_REJECTED => ['key' => DISPUTE_REJECTED, 'value' => __('message.dispute_rejected')],
        DISPUTE_UNDER_REVIEW => ['key' => DISPUTE_UNDER_REVIEW, 'value' => __('message.dispute_under_review')],
        CANCEL => ['key' => CANCEL, 'value' => __('message.cancel')],
        CLOSED => ['key' => CLOSED, 'value' => __('message.closed')],
        MONEY_RETURNED_BUYER => ['key' => MONEY_RETURNED_BUYER, 'value' => __('message.money_returned_buyer')],
        MONEY_DEPOSITED_SELLER => ['key' => MONEY_DEPOSITED_SELLER, 'value' => __('message.money_deposited_seller')],
        PAYMENT_RECEIVED => ['key' => PAYMENT_RECEIVED, 'value' => __('message.payment_received')],

    ];
    return $statusMapping[$dealHistoryStatus];
}
//get customer type color
function getCustomerTypeColor($deal, $customerId)
{
    if ($deal->deal_type == BUY) {
        return ($deal->from_customer_id == $customerId)
            ? ['color' => 'buyer-color', 'bg' => 'buyer-bg']
            : ['color' => 'seller-color', 'bg' => 'seller-bg'];
    } elseif ($deal->deal_type == SELL) {
        return ($deal->from_customer_id == $customerId)
            ? ['color' => 'seller-color', 'bg' => 'seller-bg']
            : ['color' => 'buyer-color', 'bg' => 'buyer-bg'];
    }
    return null;
}

//get customer column type
function getCustomerColumn($deal, $customerId)
{
    if ($deal->from_customer_id == $customerId) {
        return 'from_customer_id';
    } elseif ($deal->to_customer_id == $customerId) {
        return 'to_customer_id';
    }
    return null;
}
function videosExtensions()
{
    return ['mp4', 'mov', 'avi', 'mkv', 'webm', '3gp', 'flv', 'wmv'];
}
function imageExtensions()
{
    return ['jpg', 'jpeg', 'webp', 'png', 'gif', 'heic', 'svg'];
}
function docExtensions()
{
    return ['pdf', 'doc', 'docx'];
}
function multimediaType($fileExtension)
{
    $fileType = '';
    if (in_array($fileExtension, imageExtensions())) {
        return $fileType = 'image';
    } elseif (in_array($fileExtension, docExtensions())) {
        return $fileType = 'doc';
    }
    return $fileType;
}
function multimediaTypeWithVideo($fileExtension)
{
    $fileType = '';
    if (in_array($fileExtension, imageExtensions())) {
        return $fileType = 'image';
    } elseif (in_array($fileExtension, videosExtensions())) {
        return $fileType = 'video';
    }
    return $fileType;
}
function generateVideoThumbnail($video, $path)
{
    $storagePath = public_path($path);
    $fullPath = str_replace('\\', '/', $storagePath . '/' . $video);


    $thumbnailName = 'poster_' . time() . '.jpg';
    $thumbnailPath = $storagePath . '/' . $thumbnailName;

    // Ensure FFmpeg is installed and accessible
    $ffmpeg = \FFMpeg\FFMpeg::create([
        'ffmpeg.binaries' => '/usr/bin/ffmpeg',
        'ffprobe.binaries' => '/usr/bin/ffprobe',
        'timeout'          => 3600,
        'ffmpeg.threads'   => 12,
    ]);
    // $ffmpeg = \FFMpeg\FFMpeg::create(); will auto-use global ffmpeg if available


    $video = $ffmpeg->open($fullPath);
    $frame = $video->frame(\FFMpeg\Coordinate\TimeCode::fromSeconds(1)); // Capture at 1 second
    $frame->save($thumbnailPath);

    return $thumbnailName;
}
function disputeCreaedByWhichCustomer($from, $to, $dealType)
{
    if ($dealType == BUY) {
        $disputedBy = $from;
    } elseif ($dealType == SELL) {
        $disputedBy = $to;
    }
    return $disputedBy;
}
function getBuyerSellerDetails($deal)
{
    if (!$deal) {
        return null;
    }

    if ($deal->deal_type == BUY) {
        $buyer = CustomerModel::withTrashed()->select('id', 'full_name', 'deleted_at')
            ->where('id', $deal->from_customer_id)
            ->first();

        $seller = CustomerModel::withTrashed()->select('id', 'full_name', 'deleted_at')
            ->where('id', $deal->to_customer_id)
            ->first();
    } elseif ($deal->deal_type == SELL) {
        $seller = CustomerModel::withTrashed()->select('id', 'full_name', 'deleted_at')
            ->where('id', $deal->from_customer_id)
            ->first();

        $buyer = CustomerModel::withTrashed()->select('id', 'full_name', 'deleted_at')
            ->where('id', $deal->to_customer_id)
            ->first();
    } else {
        return null;
    }

    return [
        BUYER => $buyer,
        SELLER => $seller
    ];
}
function deletedCustomer($customer)
{
    if (!empty($customer) && !empty($customer->deleted_at)) {
        return "<span class='deleted-cust'>" . __('message.customer_deleted') . "</span>";
    }
    return ""; // Return empty string if not deleted
}
function formatCardNumber($number)
{
    return trim(chunk_split($number, 4, ' '));
}

function paymentStatusFilter()
{
    return [

        PAYMENT_RECEIVED => __('message.payment_received'),
        PAYMENT_PENDING => __('message.payment_pending'),
    ];
}
function rankFilter()
{
    return [

        STAR => __('message.star'),
        MEDAL => __('message.medal'),
    ];
}
function paymentReturnedFilter()
{
    return [
        MONEY_RETURNED_BUYER => __('message.money_returned_buyer'),
        MONEY_DEPOSITED_SELLER => __('message.money_deposited_seller'),
    ];
}
function paymentReturnedFilterDisputed()
{
    return [
        MONEY_RETURNED_BUYER => __('message.money_returned_buyer'),
        MONEY_DEPOSITED_SELLER => __('message.money_deposited_seller'),
        PAYMENT_RECEIVED => __('message.payment_received'),
    ];
}
function paymentReturnedFilterCancel()
{
    return [
        MONEY_RETURNED_BUYER => __('message.money_returned_buyer'),
        MONEY_DEPOSITED_SELLER => __('message.money_deposited_seller'),
        PAYMENT_PENDING => __('message.payment_pending'),
        PAYMENT_RECEIVED => __('message.payment_received'),
    ];
}
//end deal statuses list
function closedDealStatuses()
{
    return [
        COMPLETED => __('message.completed'),
        DISPUTE_ACCEPTED => __('message.dispute_accepted'),
        DISPUTE_REJECTED => __('message.dispute_rejected'),
        CANCEL => __('message.cancel'),

    ];
}
function base64ToImage($base64String, $uploadPath)
{
    $image_parts = explode(";base64,", $base64String);
    $image_type_aux = explode("image/", $image_parts[0]);
    $image_type = $image_type_aux[1] ?? 'jpeg';
    $image_base64 = base64_decode($image_parts[1]);
    $fileName = uniqid() . '.' . $image_type;
    $filePath = public_path($uploadPath . '/' . $fileName);
    file_put_contents($filePath, $image_base64);
    return $fileName;
}
function dealTypeViceVersa($deal, $loggedin_user_id)
{
    $customerTypeArray = getCustomerType($deal, $loggedin_user_id);
    $customerType = $customerTypeArray[1];
    $dealType = $deal->deal_type;
    if ($customerType == BUYER) {
        $dealType = 'Buy';
    } else if ($customerType == SELLER) {
        $dealType = 'Sell';
    }
    return $dealType;
}
function checkProfileUpdate($customer)
{
    $requiredFields = [
        'full_name',
        'mobile_number',
        'dial_code',
        'dial_code_iso',
        'address',
        'country_id',
        'zip_code',


    ];
    foreach ($requiredFields as $field) {
        if (empty($customer->$field)) {
            $customer->is_profile_updated = 0;
            $customer->save();
            return;
        }
    }
    $customer->is_profile_updated = 1;
    $customer->save();
}
//process deals with outcome
function processDealsOutcome(DealModel $deal)
{

    if ($deal->end_reason == COMPLETED && $deal->is_release == 1) {
        //Log::info($deal->id);
        foreach (['from_customer_id', 'to_customer_id'] as $field) {
            $customer = CustomerModel::find($deal->$field);
            if ($customer) {
                $customer->increment('successful_deals_count');
                $customer->updateRank();
            }
        }

        return;
    }
    //if updated deal is cancell
    if ($deal->end_reason == CANCEL) {

        $cancelledBy = $deal->cancel_by ?? null;
        $cancelledType = $deal->cancel_type ?? null;
        if ($cancelledType && $cancelledType = CUSTOMER && $cancelledBy) {

            if ($deal->is_paid == 0) {
                badDealCount($cancelledBy);
            }
            if ($deal->is_paid == 1 && $deal->is_release == 1) {
                badDealCount($cancelledBy);
            }
        }
        return;
    }
    //if dispute deal is resolved
    if ($deal->is_release == 1 &&  in_array($deal->end_reason, [DISPUTE_ACCEPTED, DISPUTE_REJECTED])) {


        if ($deal->deal_type == BUY) {
            $buyer = $deal->from_customer_id;
            $seller = $deal->to_customer_id;
        } elseif ($deal->deal_type == SELL) {
            $seller = $deal->from_customer_id;
            $buyer = $deal->to_customer_id;
        }

        if ($deal->end_reason == DISPUTE_ACCEPTED) {
            badDealCount($seller);
        } elseif ($deal->end_reason == DISPUTE_REJECTED) {
            badDealCount($buyer);
        }
        return;
    }
}
function badDealCount($customerId)
{
    $customer = CustomerModel::find($customerId);
    if (!$customer) return;

    $customer->increment('bad_deals_count');
    $customer->increment('bad_deals_after_activation');

    if ($customer->bad_deals_after_activation >= 5) {
        $customer->status = INACTIVE;
        $customer->last_inactivated_at = now();
    }
    $customer->save();
    //dd($customerId);
}
function checkDisputeDeal($status)
{
    if (in_array($status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW, DISPUTE_ACCEPTED, DISPUTE_REJECTED])) {
        return $status  = 'disputed';
    }
    return $status;
}
function getRankIcons(?string $icon, ?string $type, int $count): string
{
    if (!$icon || !$type || $count <= 0) return '';
    $html = '';
    if ($type == MEDAL) {
        $html .= '<img src="' . asset(ADMIN_PATH . '/' . $icon) . '" width="80px">';
    } elseif ($type == STAR) {
        for ($i = 0; $i < $count; $i++) {
            $html .= '<img src="' . asset(ADMIN_PATH . '/' . $icon) . '" width="20px">';
        }
    }
    return $html;
}
function formatCurrency($amount, $currency = USD, $withSymbol = true, $withCode = true)
{
    $formatted = number_format($amount, 2, '.', ',');
    switch (strtoupper($currency)) {
        case USD:
            $result =  $formatted;
            break;
        case MXN:
            $formatted = preg_replace('/^(\d+),(\d{3},\d{3}\.\d{2})$/', '$1’$2', $formatted);
            $result =  $formatted;
            break;
        default:
            $result = $formatted;
            break;
    }
    //append with currency code
    if ($withCode) {
        $result = $result . " " . strtoupper($currency);
    }
    if ($withSymbol) {
        $result = '$' . $result;
    }
    return  $result;
}
function currencyTypeFilter($is_title = 0, $title = '')
{
    $types = [
        USD =>  USD,
        MXN =>  MXN
    ];
    $title = empty($title) ? 'Select' : $title;
    if ($is_title) {
        $types = ['' => $title] + $types;
    }

    return $types;
}
