<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class settingModel extends Model
{
    use HasFactory;
    protected $table = 'setting';
    protected $fillable = ['setting_name', 'description', 'created_at', 'updated_at', 'deleted_at'];

    public function updateSetting($update)
    {
        if (isset($update) && count($update) > 0) {
            foreach ($update as $name => $content) {
                $result = $this->where('setting_name', $name)->first();
                if ($result) {
                    $result->update(['description' => $content]);
                } else {
                    $create = [
                        'setting_name' => $name,
                        'description' => $content,
                    ];
                    $this->create($create);
                }
            }
        }
    }

    public function settingValidation($inputs = [])
    {
        $rules = [
            'transfer_fees' => 'required|numeric|min:1|max:99',
        ];
        return validator($inputs, $rules);
    }

    public function getSetting($settingNames = [])
    {
        $response = [];
        $result = $this->whereIn('setting_name', $settingNames)->get();
        if (isset($result) && count($result) > 0) {
            $response = array_column($result->toArray(), 'description', 'setting_name');
        }
        return (object) $response;
    }
}
