<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DealstatusHistoryModel extends Model
{
    use HasFactory;
    protected $table = 'deal_status_histories';
    public $timestamps = false;
    protected $fillable = [
        'deal_id',
        'status',
        'created_at'
    ];
    //save deal stataus history
    public static function saveHistory($dealId, $dealStatus)
    {

        self::create([
            'deal_id' => $dealId,
            'status' => $dealStatus,
            'created_at' => now(),
        ]);
    }
}
