<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerRankModel extends Model
{
    use HasFactory;
    protected $table = 'customer_ranks';
    protected $fillable = [
        'title_en',
        'title_es',
        'min_successful_deals',
        'icon',
        'icon_type',
        'icon_count'
    ];
    public function getTitleByLang(?string $lang = null): string
    {
        $lang = $lang ?? app()->getLocale();
        return $lang === 'es' ? $this->title_es : $this->title_en;
    }
}
