<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BannerModel extends Model
{
    use HasFactory;
    protected $table = 'banners';
    protected $fillable = [
        'image',
        'status',
        'created_at',
        'updated_at',
        'file_extension',
        'file_type',
        'video_poster'
    ];
    public function BannerValidation($inputs = [], $id = null)
    {
        $allowedExtensions = array_merge(videosExtensions(), imageExtensions());
        $mimesrules = implode(',', $allowedExtensions);

        $rules = [
            'file' => 'required|mimes:' . $mimesrules . '|max:10240' // 10MB
        ];

        if ($id) {
            $rules['file'] = 'nullable|mimes:' . $mimesrules . '|max:10240';
        }

        return Validator($inputs, $rules);
    }
    public function pagination(Request $request)
    {
        $filter = 1;
        $perPage = 10;
        $sortOrder = 'desc';
        $sortEntity = 'banners.id';


        $fields = "
            banners.*
        ";

        if ($request->has('per_page') && $request->get('per_page') != '') {
            $perPage = $request->get('per_page');
        }



        if ($request->has('status') && $request->get('status') != '') {
            $filter .= " and banners.status = '" . addslashes($request->get('status')) . "'";
        }

        if ($request->has('sort_by') && $request->get('sort_by') != '') {
            $sortEntity = $request->get('sort_by');
        }

        if ($request->has('sort_order') && $request->get('sort_order') != '') {
            $sortOrder = $request->get('sort_order');
        }

        return $this
            ->select(DB::raw($fields))
            ->whereRaw($filter)
            ->orderBy($sortEntity, $sortOrder)
            ->paginate($perPage);
    }
}
