<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class LanguageMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if ($request->is('api/*')) {
            $customer = auth('sanctum')->user(); // or CustomerAuth::user()

            if ($customer && in_array($customer->language_code, ['en', 'es'])) {
                App::setLocale($customer->language_code);
            } else {
                $locale = $request->header('Accept-Language', 'en');

                if (in_array($locale, ['en', 'es'])) {
                    App::setLocale($locale);
                } else {
                    App::setLocale('en');
                }
            }
        } else {
            if (Session::has('admin_locale')) {
                App::setLocale(Session::get('admin_locale'));
            } else {
                App::setLocale('en');
            }
        }


        return $next($request);
    }
}
