<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\CustomerModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth as CustomerAuth;

class SettingApiController extends Controller
{
    //chnage password api while login
    public function changePassword(Request $request)
    {
        $loggedCustomer =  CustomerAuth::user();
        $customer = CustomerModel::find($loggedCustomer->id);
        $validation = Validator::make(
            $request->all(),
            [
                'old_password' => 'required',
                'new_password' => [
                    'required',
                    'regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/',
                    'min:8',
                ],
                'confirm_password' => 'required|same:new_password',

            ],


        );
        if ($validation->fails()) {
            return apiResponse(400, $validation->errors()->first());
        }
        if (!Hash::check($request->old_password, $loggedCustomer->password)) {
            return apiResponse(400, __('message.old_password_incorrect'));
        }
        if (Hash::check($request->new_password, $loggedCustomer->password)) {
            return apiResponse(400, __('message.new_password_same_as_old'));
        }
        $customer->password = Hash::make($request->new_password);
        $customer->save();
        return apiResponse(200, __('message.password_changed_successfully'));
    }
    //delete customer
    public function deleteCustomer()
    {
        $loggedCustomer =  CustomerAuth::user();
        $customer = CustomerModel::find($loggedCustomer->id);
        $customer->delete();
        $customer->tokens()->delete();
        return apiResponse(200, __('message.customer_deleted_successfully'));
    }
    //get pages links
    public function getPagesLinks(Request $request)
    {
        $validation = validator::make($request->all(), [
            'lang' => 'required|in:en,es'
        ]);
        if ($validation->fails()) {
            return apiResponse(400, $validation->errors()->first());
        }
        $lang = $request->lang;
        $data = [
            // 'privacy_policy' => route('privacyPolicy', $lang),
            // 'term_policy' => route('termsConditions', $lang),
            // 'help' => route('help', $lang),
            // 'about_us' => route('aboutUs', $lang),
            'privacy_policy' => route('website.privacyPolicy'),
            'term_policy' => route('website.termsConditions'),
            'help' => route('website.contact'),
            'about_us' => route('website.about'),
        ];

        return apiResponse(200, '', $data);
    }
}
