<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class InviteController extends Controller
{
    public function handleInvite(Request $request, $token)
    {
        $userAgent = strtolower($request->header('User-Agent'));
        if (strpos($userAgent, 'iphone') !== false || strpos($userAgent, 'ipad') !== false) {
            return redirect()->away('https://apps.apple.com/us/app/sale-y-vale/id6754445011');
        } elseif (strpos($userAgent, 'android') !== false) {
            return redirect()->away('https://play.google.com/store/apps/details?id=com.it.saleyvale');
        } else {
            // desktop or unknown devices
            //return redirect()->away('https://saleYvle.com/landing');
            return redirect()->away('https://saleyvale.com/download-app');
        }
    }
}
