<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\Rule;

class PermissionController extends Controller
{


    public function create()
    {
        abort(404);
        $permissions = Permission::all()->groupBy('module');
        return view('admin.permission.create', compact('permissions'));
    }
    public function store(Request $request)
    {
        //abort(404);
        try {
            DB::beginTransaction();
            $validations =  Validator::make($request->all(), [
                'permission' => [
                    'required',
                    'min:3',
                    Rule::unique('permissions', 'name')->where(function ($query) use ($request) {
                        return $query->where('module', $request->module);
                    }),
                ],

                'module' => 'required|min:3'
            ]);

            if ($validations->fails()) {
                return jsonResponse(false, 400, $validations->errors());
            }

            Permission::create([

                'module' => $request->module,
                'name' => $request->permission . " " . "-" . " " . $request->module,
            ]);
            DB::commit();
            $message = 'Permission added successfully.';
            $extra = ['redirect' => route('admin.permission.create')];
            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollBack();
            return jsonResponse(false, 500, 'Internal server error' . $e->getMessage());
        }
    }
    public function edit() {}
    public function update() {}
    public function destry() {}
}
