<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BannerModel;
use Illuminate\Http\Request;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Support\Facades\DB;
use Illuminate\Routing\Controllers\Middleware;
use spatie\permission\Exceptions\UnauthorizedException;

class BannerController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:list - banner')->only('index');
        $this->middleware('permission:add - banner')->only(['create', 'store']);
        $this->middleware('permission:edit - banner')->only(['edit', 'update']);
        $this->middleware('permission:delete - banner')->only(['destroy']);
    }
    public function create()
    {
        // if (!auth('admin')->user()->can('Add - Banner')) {
        //     abort(404);
        // }

        return view('admin.banners.create');
    }
    public function store(Request $request)
    {
        $videoPoster = null;
        $inputs = $request->all();
        $validator = (new BannerModel)->BannerValidation($inputs);
        if ($validator->fails()) {
            return jsonResponse(false, 400, $validator->errors());
        }
        $image =  uploadFile('file', ADMIN_PATH . '/banners');
        $fileExtension = pathinfo($image, PATHINFO_EXTENSION);
        $fileType = multimediaTypeWithVideo($fileExtension);


        if ($request->filled('video_poster')) {
            $videoPoster = base64ToImage($request->video_poster, BANNER_PATH);
        }

        BannerModel::create([
            'image' => $image,
            'status' => $request->status,
            'file_type' => $fileType,
            'file_extension' => $fileExtension,
            'video_poster' => $videoPoster,

        ]);
        $message = __('message.banner_added_successfully');
        $extra = ['redirect' =>  route('admin.banner.index')];
        return jsonResponse(true, 200, $message, $extra);
    }
    public function index(request $request)
    {

        try {
            DB::beginTransaction();
            $banners = (new BannerModel())->pagination($request);
            DB::commit();
            //dd($banners);
            if ($request->ajax()) {
                return response()->json([
                    'data' => view('admin.banners.pagination', compact('banners'))->render()
                ]);
            }
            return view('admin.banners.index', compact('banners'));
        } catch (\Exception $e) {
            DB::rollBack();
            $message = __('message.internal_server_error');
            return jsonResponse(false, 400, $message);
        }
    }
    public function edit($id)
    {
        try {
            DB::beginTransaction();
            $banner =  BannerModel::find($id);
            DB::commit();
            if (!$banner) {
                return redirect()->route('admin.banner.index')->with('error', __('message.invalid_details'));
            }
            return view('admin.banners.edit', compact('banner'));
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->route('admin.banner.index')->with('error', __('message.something_went_wrong'));
        }
    }
    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();
            $videoPoster = null;
            $banner = BannerModel::find($id);
            if (!$banner) {
                $message = __('message.invalid_details');
                $extra = ['redirect' =>  route('admin.banner.index')];
                return jsonResponse(false, 500, $message, $extra);
            }
            $validator = (new BannerModel)->BannerValidation($request->all(), $id);
            if ($validator->fails()) {
                return jsonResponse(false, 400, $validator->errors());
            }
            $data = $request->except(['file']);
            if ($request->hasFile('file')) {
                //delete old file
                if (!empty($banner->image) && file_exists(public_path(BANNER_PATH . '/' . $banner->image))) {
                    unlink(public_path(BANNER_PATH . '/' . $banner->image));
                }
                if (!empty($banner->video_poster) && file_exists(public_path(BANNER_PATH . '/' . $banner->video_poster))) {
                    unlink(public_path(BANNER_PATH . '/' . $banner->video_poster));
                }

                $image =  uploadFile('file', ADMIN_PATH . '/banners', $banner->image);
                $fileExtension = pathinfo($image, PATHINFO_EXTENSION);
                $fileType = multimediaTypeWithVideo($fileExtension);

                $data['image'] = $image;
                $data['file_extension'] = $fileExtension;
                $data['file_type'] = $fileType;

                // $data['video_poster'] = generateVideoThumbnail($image, BANNER_PATH);
                if ($fileType === 'video') {
                    if ($request->filled('video_poster')) {
                        $data['video_poster'] = base64ToImage($request->video_poster, BANNER_PATH);
                    }
                } else {
                    $data['video_poster'] = '';
                }
            }
            //dd($data);
            $banner->update($data);
            DB::commit();
            $message = __('message.banner_updated_successfully');
            $extra = ['redirect' =>  route('admin.banner.index')];
            return jsonResponse(true, 200, $message, $extra);
        } catch (\Exception $e) {
            DB::rollback();
        }
    }
    public function destroy($id)
    {
        $banner = BannerModel::find($id);
        if (!empty($banner)) {
            if ($banner->image && file_exists(public_path('uploads/admin/banners/' . $banner->image))) {
                unlink(public_path('uploads/admin/banners/' . $banner->image));
            }
            try {
                DB::beginTransaction();
                $banner->delete();
                DB::commit();
                $message = __('message.banner_deleted_successfully');
                $extra = ['redirect' => route('admin.banner.index')];
                return jsonResponse(true, 200, $message, $extra);
            } catch (\Exception $e) {
                DB::rollBack();
                $message = __('message.internal_server_error') . $e->getMessage();
                $extra = ['redirect' => route('admin.banner.index')];
                return jsonResponse(false, 500, $message, $extra);
            }

            // return redirect()->route('admin.customer')->with('success', 'Customer deleted successfully.');
        } else {
            $message = __('message.invalid_details');
            $extra = ['redirect' => route('admin.banner.index')];
            return jsonResponse(false, 500, $message, $extra);
        }
    }
}
