<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DealModel;
use Illuminate\Http\Request;
use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Style\Style;
use Box\Spout\Common\Entity\Style\CellAlignment;
use Illuminate\Support\Facades\Response;


class AllDealsTypesExportController extends Controller
{
    //ongoing deals list report
    public function exportOngoingDeals(Request $request)
    {
        $deals = DealModel::ongoingDealsPagination($request)->get(); // your existing query

        $writer = WriterEntityFactory::createXLSXWriter();
        $fileName = 'ongoing_deals_' . date('d-m-Y_H-i') . '.xlsx';
        $filePath = storage_path('app/public/' . $fileName);
        $writer->openToFile($filePath);

        // Header row
        $headerStyle = (new Style())
            ->setFontBold()
            ->setCellAlignment(CellAlignment::CENTER);

        $headers = ['Deal Number', 'Title', 'Amount', 'Status', 'Payment Status', 'Seller', 'Buyer'];
        $headerRow = WriterEntityFactory::createRowFromArray($headers, $headerStyle);
        $writer->addRow($headerRow);

        // Data rows
        foreach ($deals as $deal) {
            $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
            $row = WriterEntityFactory::createRowFromArray([
                $deal->deal_number,
                $deal->deal_title,
                $deal->deal_amount,
                $deal->deal_status,
                $paymentStatusResult['payment_status'],
                $deal->seller_name,
                $deal->buyer_name
            ]);
            $writer->addRow($row);
        }

        $writer->close();

        return response()->download($filePath)->deleteFileAfterSend(true);
    }
    //amount on hold  deals list report
    public function exportOnholdDeals(Request $request)
    {
        $deals = DealModel::holdAmountDealsPagination($request)->get(); // your existing query

        $writer = WriterEntityFactory::createXLSXWriter();
        $fileName = 'amount_on_hold_deals_' . date('d-m-Y_H-i') . '.xlsx';
        $filePath = storage_path('app/public/' . $fileName);
        $writer->openToFile($filePath);

        // Header row
        $headerStyle = (new Style())
            ->setFontBold()
            ->setCellAlignment(CellAlignment::CENTER);

        $headers = ['Deal Number', 'Title', 'Amount', 'Status', 'Payment Status', 'Seller', 'Buyer'];
        $headerRow = WriterEntityFactory::createRowFromArray($headers, $headerStyle);
        $writer->addRow($headerRow);

        // Data rows
        foreach ($deals as $deal) {
            $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
            $row = WriterEntityFactory::createRowFromArray([
                $deal->deal_number,
                $deal->deal_title,
                $deal->deal_amount,
                $deal->deal_status,
                $paymentStatusResult['payment_status'],
                $deal->seller_name,
                $deal->buyer_name
            ]);
            $writer->addRow($row);
        }

        $writer->close();

        return response()->download($filePath)->deleteFileAfterSend(true);
    }
    //disputed dea;s report
    public function exportDisputeDeals(Request $request)
    {
        $deals = DealModel::disputedDealsPagination($request)->get(); // your existing query

        $writer = WriterEntityFactory::createXLSXWriter();
        $fileName = 'dispute_deals_' . date('d-m-Y_H-i') . '.xlsx';
        $filePath = storage_path('app/public/' . $fileName);
        $writer->openToFile($filePath);

        // Header row
        $headerStyle = (new Style())
            ->setFontBold()
            ->setCellAlignment(CellAlignment::CENTER);

        $headers = ['Deal Number', 'Title', 'Amount', 'Status', 'Payment Status', 'Seller', 'Buyer'];
        $headerRow = WriterEntityFactory::createRowFromArray($headers, $headerStyle);
        $writer->addRow($headerRow);

        // Data rows
        foreach ($deals as $deal) {
            $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
            $statusOptions = dealStatusFilter();
            $row = WriterEntityFactory::createRowFromArray([
                $deal->deal_number,
                $deal->deal_title,
                $deal->deal_amount,
                $statusOptions[$deal->deal_status] ?? $deal->status,
                $paymentStatusResult['payment_status'],
                $deal->seller_name,
                $deal->buyer_name
            ]);
            $writer->addRow($row);
        }

        $writer->close();

        return response()->download($filePath)->deleteFileAfterSend(true);
    }
    //cancel deals report
    public function exportCancelDeals(Request $request)
    {
        $deals = DealModel::cancelledDealsPagination($request)->get(); // your existing query

        $writer = WriterEntityFactory::createXLSXWriter();
        $fileName = 'cancel_deals_' . date('d-m-Y_H-i') . '.xlsx';
        $filePath = storage_path('app/public/' . $fileName);
        $writer->openToFile($filePath);

        // Header row
        $headerStyle = (new Style())
            ->setFontBold()
            ->setCellAlignment(CellAlignment::CENTER);

        $headers = ['Deal Number', 'Title', 'Amount', 'Status', 'Payment Status', 'Seller', 'Buyer'];
        $headerRow = WriterEntityFactory::createRowFromArray($headers, $headerStyle);
        $writer->addRow($headerRow);

        // Data rows
        foreach ($deals as $deal) {
            $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
            $row = WriterEntityFactory::createRowFromArray([
                $deal->deal_number,
                $deal->deal_title,
                $deal->deal_amount,
                $deal->deal_status,
                $paymentStatusResult['payment_status'],
                $deal->seller_name,
                $deal->buyer_name
            ]);
            $writer->addRow($row);
        }

        $writer->close();

        return response()->download($filePath)->deleteFileAfterSend(true);
    }
    //closed deals report
    public function exportClosedDeals(Request $request)
    {
        $deals = DealModel::closedDealsPagination($request)->get(); // your existing query

        $writer = WriterEntityFactory::createXLSXWriter();
        $fileName = 'closed_deals_' . date('d-m-Y_H-i') . '.xlsx';
        $filePath = storage_path('app/public/' . $fileName);
        $writer->openToFile($filePath);

        // Header row
        $headerStyle = (new Style())
            ->setFontBold()
            ->setCellAlignment(CellAlignment::CENTER);

        $headers = ['Deal Number', 'Title', 'Amount', 'Status', 'Payment Status', 'Seller', 'Buyer'];
        $headerRow = WriterEntityFactory::createRowFromArray($headers, $headerStyle);
        $writer->addRow($headerRow);

        // Data rows
        foreach ($deals as $deal) {
            $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
            $row = WriterEntityFactory::createRowFromArray([
                $deal->deal_number,
                $deal->deal_title,
                $deal->deal_amount,
                $deal->deal_status,
                $paymentStatusResult['payment_status'],
                $deal->seller_name,
                $deal->buyer_name
            ]);
            $writer->addRow($row);
        }

        $writer->close();

        return response()->download($filePath)->deleteFileAfterSend(true);
    }
    //disputed dea;s report
    public function exportDeclinedDeals(Request $request)
    {
        $deals = DealModel::declinedDealsPagination($request)->get(); // your existing query

        $writer = WriterEntityFactory::createXLSXWriter();
        $fileName = 'declined_deals_' . date('d-m-Y_H-i') . '.xlsx';
        $filePath = storage_path('app/public/' . $fileName);
        $writer->openToFile($filePath);

        // Header row
        $headerStyle = (new Style())
            ->setFontBold()
            ->setCellAlignment(CellAlignment::CENTER);

        $headers = ['Deal Number', 'Title', 'Amount', 'Status', 'Payment Status', 'Seller', 'Buyer'];
        $headerRow = WriterEntityFactory::createRowFromArray($headers, $headerStyle);
        $writer->addRow($headerRow);

        // Data rows
        foreach ($deals as $deal) {
            $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
            $row = WriterEntityFactory::createRowFromArray([
                $deal->deal_number,
                $deal->deal_title,
                $deal->deal_amount,
                $deal->deal_status,
                $paymentStatusResult['payment_status'],
                $deal->seller_name,
                $deal->buyer_name
            ]);
            $writer->addRow($row);
        }

        $writer->close();

        return response()->download($filePath)->deleteFileAfterSend(true);
    }
}
