<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AdminModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class AdminController extends Controller
{
    //Display login panel
    public function index()
    {
        return view('auth.login');
    }
    //admin authentiction
    public function login_authentication(Request $request)
    {
        $validators = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required'
        ]);
        if ($validators->fails()) {
            return redirect()->route('admin.login')->withInput()->withErrors($validators);
        }
        $admin = AdminModel::where('email', $request->email)->first();
        if ($admin) {
            if ($admin->status === 'inactive' && !$admin->hasRole('superadmin')) {
                return redirect()->route('admin.login')->withInput()->with('error', __('message.account_inactive'));
            }
            if (Auth::guard('admin')->attempt(['email' => $request->email, 'password' => $request->password])) {

                return redirect()->route('admin.dashboard');
            }
            return redirect()->route('admin.login')->withInput()->with('error', __('message.email_or_password_incorrect'));
        }
        return redirect()->route('admin.login')->withInput()->with('error', __('message.no_account_found'));
    }

    //save admin data
    public function store()
    {
        AdminModel::create([
            'name' => 'admin',
            'email' => 'admin@gmail.com',
            'password' => Hash::make('123456'),
        ]);
    }

    public function logout(Request $request)
    {
        Auth::guard('admin')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('admin.login')->with('success', __('message.logout_success'));
    }
}
