<?php

namespace App\Console\Commands;

use App\Models\DealModel;
use Illuminate\Console\Command;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class AutoCancelPendingDeals extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'deals:cancel-pending';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Cancel deals that are pending for more than 7 days';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $dateLimit = Carbon::now()->subDays(7);
        $deals = DealModel::where('deal_status', 'pending')->where('created_at', '<', $dateLimit)->get();
        foreach ($deals as $deal) {
            $deal->deal_status = CANCEL;
            $deal->save();
        }
        Log::info(' Auto-cancel command completed. Deals cancelled: ' . $deals->count());
    }
}
