<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>
    <script>
        let earningTypes = [];
        let earningsData = [];
    </script>
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <?php if(
                $authUser->hasPermissionTo('list - ongoing deals') ||
                    $authUser->hasPermissionTo('list - Cancelled Deals') ||
                    $authUser->hasPermissionTo('list - hold amount deals') ||
                    $authUser->hasPermissionTo('list - dispute deals') ||
                    $authUser->hasPermissionTo('buy and sell statistics - dashboard') ||
                    $authUser->hasPermissionTo('earnings chart - dashboard') ||
                    $authUser->id == 1): ?>
                <div class="row">
                    <?php if(
                        $authUser->hasPermissionTo('list - ongoing deals') ||
                            $authUser->hasPermissionTo('list - Cancelled Deals') ||
                            $authUser->hasPermissionTo('list - hold amount deals') ||
                            $authUser->hasPermissionTo('list - dispute deals') ||
                            $authUser->id == 1): ?>
                        <div class="col-md-8">
                            <div class="row ">
                                
                                <?php if($authUser->hasPermissionTo('list - ongoing deals') || $authUser->id == 1): ?>
                                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="card-title d-flex align-items-start justify-content-between">
                                                    <div class="avatar flex-shrink-0">
                                                        <img src="<?php echo e(asset('admin-assets/img/icons/circular.png')); ?>"
                                                            alt="ongoing deals" class="rounded" />
                                                    </div>

                                                </div>
                                                <a href="<?php echo e(route('admin.deals.ongoing')); ?>">
                                                    <span class="fw-semibold d-block mb-1 text-success"> <?php echo app('translator')->get('message.on_going_deals'); ?>:
                                                        <?php echo e($data['ongoingDeals']['count'] ?? 0); ?></span>
                                                </a>


                                                <h5 class="card-title mb-2">
                                                    <?php echo e(formatCurrency($data['ongoingDeals']['usd_total'], USD, 0, 1)); ?>


                                                    <span class="text-danger"> (<?php echo e($data['ongoingDeals']['usd_deals']); ?>

                                                        Deals)</span>
                                                </h5>
                                                <h5 class="card-title mb-2">
                                                    <?php echo e(formatCurrency($data['ongoingDeals']['mxn_total'], MXN, 0, 1)); ?>

                                                    <span class="text-danger">(<?php echo e($data['ongoingDeals']['mxn_deals']); ?>

                                                        Deals)</span>
                                                </h5>


                                                
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if($authUser->hasPermissionTo('list - dispute deals') || $authUser->id == 1): ?>
                                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="card-title d-flex align-items-start justify-content-between">
                                                    <div class="avatar flex-shrink-0">
                                                        <img src="<?php echo e(asset('admin-assets/img/icons/disputes.png')); ?>"
                                                            alt="disputed deals" class="rounded" />
                                                    </div>

                                                </div>
                                                <a href="<?php echo e(route('admin.deals.disputed')); ?>">
                                                    <span class="fw-semibold d-block mb-1 text-success"> <?php echo app('translator')->get('message.disputed_deals'); ?>:
                                                        <?php echo e($data['disputedDeals']['count'] ?? 0); ?></span>
                                                </a>


                                                <h5 class="card-title mb-2">
                                                    <?php echo e(formatCurrency($data['disputedDeals']['usd_total'], USD, 0, 1)); ?>


                                                    <span class="text-danger"> (<?php echo e($data['disputedDeals']['usd_deals']); ?>

                                                        Deals)</span>
                                                </h5>
                                                <h5 class="card-title mb-2">
                                                    <?php echo e(formatCurrency($data['disputedDeals']['mxn_total'], MXN, 0, 1)); ?>

                                                    <span class="text-danger">(<?php echo e($data['disputedDeals']['mxn_deals']); ?>

                                                        Deals)</span>
                                                </h5>

                                                
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if($authUser->hasPermissionTo('list - Cancelled Deals') || $authUser->id == 1): ?>
                                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="card-title d-flex align-items-start justify-content-between">
                                                    <div class="avatar flex-shrink-0">
                                                        <img src="<?php echo e(asset('admin-assets/img/icons/cancelled.png')); ?>"
                                                            alt="ongoing deals" class="rounded" />
                                                    </div>

                                                </div>
                                                <a href="<?php echo e(route('admin.deals.cancelled')); ?>">
                                                    <span class="text-success fw-semibold d-block mb-1"> <?php echo app('translator')->get('message.cancel_deals'); ?>:
                                                        <?php echo e($data['cancelDeals']['count'] ?? 0); ?></span>
                                                </a>



                                                <h5 class="card-title mb-2">
                                                    <?php echo e(formatCurrency($data['cancelDeals']['usd_total'], USD, 0, 1)); ?>


                                                    <span class="text-danger"> (<?php echo e($data['cancelDeals']['usd_deals']); ?>

                                                        Deals)</span>
                                                </h5>
                                                <h5 class="card-title mb-2">
                                                    <?php echo e(formatCurrency($data['cancelDeals']['mxn_total'], MXN, 0, 1)); ?>

                                                    <span class="text-danger">(<?php echo e($data['cancelDeals']['mxn_deals']); ?>

                                                        Deals)</span>
                                                </h5>

                                                
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if($authUser->hasPermissionTo('list - hold amount deals') || $authUser->id == 1): ?>
                                    <div class="col-lg-6 col-md-12 col-6 mb-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="card-title d-flex align-items-start justify-content-between">
                                                    <div class="avatar flex-shrink-0">
                                                        <img src="<?php echo e(asset('admin-assets/img/icons/pause.png')); ?>"
                                                            alt="ongoing deals" class="rounded" />
                                                    </div>

                                                </div>
                                                <a href="<?php echo e(route('admin.deals.holdAmount')); ?>">
                                                    <span class="fw-semibold d-block mb-1 text-success"> <?php echo app('translator')->get('message.hold_amount_deals'); ?>:
                                                        <?php echo e($data['holdDeals']['count'] ?? 0); ?></span>
                                                </a>
                                                <h5 class="card-title mb-2">
                                                    <?php echo e(formatCurrency($data['holdDeals']['usd_total'], USD, 0, 1)); ?>


                                                    <span class="text-danger"> (<?php echo e($data['holdDeals']['usd_deals']); ?>

                                                        Deals)</span>
                                                </h5>
                                                <h5 class="card-title mb-2">
                                                    <?php echo e(formatCurrency($data['holdDeals']['mxn_total'], MXN, 0, 1)); ?>

                                                    <span class="text-danger">(<?php echo e($data['holdDeals']['mxn_deals']); ?>

                                                        Deals)</span>
                                                </h5>
                                                
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($authUser->hasPermissionTo('buy and sell statistics - dashboard') || $authUser->id == 1): ?>
                        <div class="col-md-4">
                            <div class=" order-0 mb-4">
                                <div class="card h-100">
                                    <div class="">
                                        <div class="card-title mb-0">
                                            <div class="commisison-display p-4">
                                                <h6 class="m-0 "><?php echo app('translator')->get('message.transfer_fees'); ?> : </h6>
                                                <div class="total_commision_currency">
                                                    <h6 class="mb-2">
                                                        <?php echo e(formatCurrency($data['commissionUSD'], USD, 0, 1)); ?>

                                                    </h6>
                                                    <h6 class="mb-0">
                                                        <?php echo e(formatCurrency($data['commissionMXN'], MXN, 0, 1)); ?>

                                                    </h6>
                                                </div>



                                            </div>


                                        </div>

                                    </div>

                                </div>
                            </div>
                            <div class=" order-0 mb-4">
                                <div class="card h-100">
                                    <div class="card-header d-flex align-items-center justify-content-between pb-0">
                                        <div class="card-title mb-0">
                                            <h5 class="m-0 me-2"><?php echo app('translator')->get('message.sale_statistics'); ?></h5>

                                        </div>

                                    </div>
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div class="d-flex flex-column align-items-center gap-1">
                                                <h2 class="mb-2"><?php echo e($data['totalDeals']); ?></h2>
                                                <span><?php echo app('translator')->get('message.total_deals'); ?></span>
                                            </div>
                                            <script>
                                                var totalBuyDeals = <?php echo json_encode($data['totalBuyDeals'] ?? 0, 15, 512) ?>;
                                                var totalSellDeals = <?php echo json_encode($data['totalSellDeals'] ?? 0, 15, 512) ?>;
                                            </script>
                                            <div id="orderStatisticsChart"></div>
                                        </div>
                                        <ul class="p-0 m-0">
                                            <li class="d-flex mb-4 pb-1">
                                                <div class=" flex-shrink-0 me-3">
                                                    <img src="<?php echo e(asset('admin-assets/img/sell.png')); ?>" alt="">
                                                </div>
                                                <div
                                                    class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                    <div class="me-2 ">
                                                        <h6 class="mb-0 seller-color"> <?php echo app('translator')->get('message.seller'); ?></h6>

                                                    </div>
                                                    <div class="user-progress">
                                                        <small class="fw-semibold"><?php echo e($data['totalSellDeals']); ?></small>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="d-flex mb-4 pb-1">
                                                <div class=" flex-shrink-0 me-3">
                                                    <img src="<?php echo e(asset('admin-assets/img/buy.png')); ?>" alt="">
                                                </div>
                                                <div
                                                    class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                                                    <div class="me-2 ">
                                                        <h6 class="mb-0 buyer-color"> <?php echo app('translator')->get('message.buyer'); ?></h6>

                                                    </div>
                                                    <div class="user-progress">
                                                        <small class="fw-semibold"><?php echo e($data['totalBuyDeals']); ?></small>
                                                    </div>
                                                </div>
                                            </li>


                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if($authUser->hasPermissionTo('earnings chart - dashboard') || $authUser->id == 1): ?>
                    <div class="row">
                        <div class="col-12">
                            <div class="card">

                                <div class="card-body">
                                    <div class="years-selection">
                                        
                                        <select name="earningsYears" id="earningsYears" onchange="updateChart()"
                                            class="form-select">
                                            <option value="all">All</option>
                                            <?php $__currentLoopData = $data['availableYears']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($year); ?>"
                                                    <?php echo e($year == $data['selectedYear'] ? 'selected' : ''); ?>>
                                                    <?php echo e($year); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                        </select>


                                    </div>
                                    <h5 class="text-center" id="chart_title">
                                        <?php echo e(__('message.yearly_earnings', ['year' => $data['selectedYear']])); ?>

                                    </h5>
                                    <div>
                                        <canvas style="height:250px!important;" id="myChart"></canvas>
                                    </div>

                                </div>


                                <?php if($authUser->hasPermissionTo('earnings chart - dashboard') || $authUser->id == 1): ?>
                                    <script>
                                        earningTypes = <?php echo json_encode($data['earningTypes'], 15, 512) ?>;
                                        usdData = <?php echo json_encode($data['usdData'], 15, 512) ?>;
                                        mxnData = <?php echo json_encode($data['mxnData'], 15, 512) ?>;
                                    </script>
                                <?php endif; ?>

                            </div>
                        </div>
                        

                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="row">
                    <div class="col-12">
                        <div class="row ">
                            <div class="col-lg-6 col-md-12 col-6 mb-4">
                                <div class="card">
                                    <div class="card-body">


                                        <h3 class="card-title mb-2">
                                            <?php echo app('translator')->get('message.no_content'); ?>

                                        </h3>
                                        
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>

                </div>
            <?php endif; ?>
        </div>
        <!-- / Content -->

    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>
        <?php if($authUser->hasPermissionTo('earnings chart - dashboard') || $authUser->id == 1): ?>
            <script>
                const ctx = document.getElementById('myChart');

                const myChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: earningTypes,
                        datasets: [{
                                label: 'USD',
                                data: usdData,
                                backgroundColor: 'rgba(54, 162, 235, 0.7)'
                            },
                            {
                                label: 'MXN',
                                data: mxnData,
                                backgroundColor: 'rgba(255, 99, 132, 0.7)'
                            }
                        ]
                    },
                    options: {
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                ticks: {
                                    callback: function(value) {
                                        return '$' + value; // or 'MX$' if you want
                                    }
                                }
                            }
                        }
                    }
                });

                function updateChart() {
                    let earningsYears = $('#earningsYears').val();

                    $.ajax({
                        url: "<?php echo e(route('admin.dashboard.getEarnings')); ?>",
                        type: "GET",
                        data: {
                            requestedData: earningsYears
                        },
                        success: function(response) {
                            if (response.status === true && response.statusCode === 200) {
                                let earnings = response.extra.data;
                                myChart.data.labels = earnings.earningTypes;
                                myChart.data.datasets[0].data = earnings.usdData || [];
                                myChart.data.datasets[1].data = earnings.mxnData || [];
                                myChart.update();
                                $("#chart_title").html(response.extra.title);
                            }
                        },
                        error: function(xhr) {
                            console.error("Error fetching earnings data:", xhr.responseText);
                        }
                    });
                }
                //submit export excel form exportBtn
                $('#exportBtn').on('click', function(e) {
                    e.preventDefault();
                    $('#exportExcel').submit();
                })
            </script>
        <?php endif; ?>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/deal/resources/views/admin/default/dashboard.blade.php ENDPATH**/ ?>