<?php $__env->startSection('title', 'Customer Rank'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">

        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row ">
                <div class="col-12">
                    <!-- Hoverable Table rows -->
                    <div class="card px-4 pt-4">

                        <?php if(session('success')): ?>
                            <div class="alert alert-success pt-2">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger pt-2">
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>



                        <div class="mt-5 d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark"><?php echo app('translator')->get('message.customer_rank_list'); ?></h3>

                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div id="pagination-table">
                                    <table class=" dt-responsive table table-hover display align-middle mb-0">
                                        <thead>
                                            <tr>

                                                <th>
                                                    <?php echo app('translator')->get('message.title'); ?>
                                                </th>

                                                <th>
                                                    <?php echo app('translator')->get('message.min_successful_deals'); ?>
                                                </th>

                                                <th>
                                                    <?php echo app('translator')->get('message.icon_or_image'); ?>
                                                </th>

                                                <th>
                                                    <?php echo app('translator')->get('message.icon_type'); ?>
                                                </th>

                                                <th>
                                                    <?php echo app('translator')->get('message.icon_count'); ?>
                                                </th>

                                                <th> <?php echo app('translator')->get('message.actions'); ?></span></th>
                                            </tr>
                                        </thead>
                                        <?php if(isset($ranks) && count($ranks) > 0): ?>
                                            <tbody class="table-border-bottom-0">

                                                <?php $__currentLoopData = $ranks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>

                                                        <td class="text-capitalize">
                                                            <?php echo e($rank->getTitleByLang()); ?></td>
                                                        <td class="text-capitalize"><?php echo e($rank->min_successful_deals); ?></td>
                                                        <td class="text-capitalize">
                                                            <?php if(!empty($rank->icon)): ?>
                                                                <img width="30" class=""
                                                                    src="<?php echo e(asset(RANK_ICONS . '/' . $rank->icon)); ?>"
                                                                    alt="">
                                                            <?php else: ?>
                                                                <p class="text-muted"><?php echo app('translator')->get('message.no_icon_available'); ?></p>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="text-capitalize"><?php echo e($rank->icon_type); ?></td>
                                                        <td class="text-capitalize"><?php echo e($rank->icon_count); ?></td>

                                                        <td>
                                                            <?php if($authUser->hasPermissionTo('edit - customer rank') || $authUser->id == 1): ?>
                                                                <div class="d-flex">


                                                                    <a class="btn-role"
                                                                        href="<?php echo e(route('admin.customerRank.edit', $rank->id)); ?>">
                                                                        <i class="bx bx-edit"></i></a>


                                                                    


                                                                </div>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>



                                            </tbody>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tbody>
                                            <tr>
                                                <td colspan ="3" class="text-danger">No Rank created</td>
                                            </tr>
                                        </tbody>
                                        <?php endif; ?>
                                    </table>

                                </div>
                            </div>
                        </div>

                    </div>
                    <!--/ Hoverable Table rows -->
                </div>
            </div>

        </div>
        <!-- / Content -->
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/deal/resources/views/admin/customer-ranks/index.blade.php ENDPATH**/ ?>