<!DOCTYPE html>
<html>

<head>
    <title>Deal Detail</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
        }

        .header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .badge-danger {
            background: rgb(219, 14, 14);
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
        }

        .badge-success {
            background: rgb(2, 117, 40);
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
        }

        .box {
            border: 1px solid #ddd;
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 6px;
        }

        .section-title {
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th,
        td {
            padding: 8px;
            text-align: right;
        }

        th {
            text-align: left;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
        }

        .logo {
            display: flex;
            justify-content: end;
            text-align: right;
        }
    </style>
</head>

<body>

    <div class="header">
        <div class="logo">
            <img src="<?php echo e(public_path('admin-assets/img/logo.png')); ?>" alt="">
        </div>
        <div>
            <h2><?php echo app('translator')->get('message.deal'); ?> #<?php echo e($deal_data->deal_number); ?>

                <?php if($deal_data->deal_status == COMPLETED): ?>
                    <span class="badge-success"><?php echo e(ucwords(str_replace('_', ' ', $deal_data->deal_status))); ?></span>
                <?php else: ?>
                    <span class="badge-danger"><?php echo e(ucwords(str_replace('_', ' ', $deal_data->deal_status))); ?></span>
                <?php endif; ?>


            </h2>
            <span><strong><?php echo e(ucfirst($deal_data->deal_title)); ?></strong></span>

            <p><strong><?php echo app('translator')->get('message.customer_list_name'); ?> : </strong><?php echo e(ucfirst($deal_data->second_party->second_party_name)); ?></p>
            <p><strong><?php echo app('translator')->get('message.customer_list_mobile'); ?>:
                </strong><?php echo e($deal_data->second_party->second_party_dial_code); ?>&nbsp;<?php echo e($deal_data->second_party->second_party_mobile_number); ?>

            </p>
            <?php if($deal_data->second_party->second_party_address): ?>
                <p><strong><?php echo app('translator')->get('message.address'); ?> : </strong> <?php echo e($deal_data->second_party->second_party_address); ?>

            <?php endif; ?>
            <br>
            <?php if($deal_data->second_party->cityName): ?>
                <?php echo e($deal_data->second_party->cityName); ?>,&nbsp;
            <?php endif; ?>
            <?php if($deal_data->second_party->second_party_state): ?>
                <?php echo e($deal_data->second_party->second_party_state); ?>,&nbsp;
            <?php endif; ?>
            <?php if($deal_data->second_party->second_party_country): ?>
                <?php echo e($deal_data->second_party->second_party_country); ?>,&nbsp;
            <?php endif; ?>
            </p>


        </div>

    </div>




    <div class="box">
        <p class="section-title"><?php echo app('translator')->get('message.date_time'); ?></p>
        <p><?php echo e($deal_data->deal_created_date); ?> at <?php echo e($deal_data->deal_created_time); ?></p>
    </div>

    <div class="box">
        <p class="section-title"><?php echo app('translator')->get('message.payment_details'); ?></p>
        <?php if($deal_data->customer_type == BUYER): ?>
            <table>
                <tr>
                    <th><?php echo app('translator')->get('message.item_price'); ?></th>
                    <td>$<?php echo e($deal_data->deal_amount); ?></td>
                </tr>

                <tr>
                    <th><?php echo app('translator')->get('message.commission'); ?> %</th>
                    <td>$<?php echo e($deal_data->commission_amount); ?></td>

                </tr>


                <tr>
                    <th><?php echo app('translator')->get('message.total_amount_paid'); ?></th>
                    <td><strong>$<?php echo e($deal_data->total_deal_amount); ?></strong></td>
                </tr>
            </table>
        <?php elseif($deal_data->customer_type == SELLER): ?>
            <table>
                <tr>
                    <th><?php echo app('translator')->get('message.item_price'); ?></th>
                    <td>$<?php echo e($deal_data->deal_amount); ?></td>
                </tr>


                <tr>
                    <th><?php echo app('translator')->get('message.received_amount'); ?></th>
                    <td><strong>$<?php echo e($deal_data->deal_amount); ?></strong></td>
                </tr>
            </table>
        <?php endif; ?>
    </div>

    <div class="footer">
        <?php echo app('translator')->get('message.thank_you'); ?>
    </div>

</body>

</html>
<?php /**PATH /home/intellisensetech/public_html/deal/resources/views/admin/pdf/deal_detail.blade.php ENDPATH**/ ?>