<?php $__env->startSection('title', 'Edit Customer'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper ">
        <div class="content-wrapper">
            <div class="container-xxl flex-grow-1 container-p-y">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <!-- Basic Layout -->
                <div class="row ">
                    <div class="col-md-7">
                        <div class="card mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="mb-0 text-dark text-uppercase">
                                    <?php echo app('translator')->get('message.view_deal'); ?> #<?php echo e($deal->deal_number); ?>


                                </h4>
                                <h5>
                                    <?php if(!empty($deal->end_reason)): ?>
                                        <?php echo getDealstatusWithColor($deal->end_reason); ?>

                                    <?php endif; ?>
                                    <?php echo getDealstatusWithColor($deal->deal_status); ?>


                                    <?php if($deal->is_hold == 1): ?>
                                        <span class="badge bg-warning"><?php echo app('translator')->get('message.amount_hold'); ?></span>
                                    <?php endif; ?>

                                </h5>
                            </div>
                            <div class="card-body">
                                <?php if($deal->deal_status === COMPLETED || $deal->end_reason === COMPLETED): ?>
                                    <div class="d-flex justify-space-between">
                                        <?php if(($deal->deal_status === COMPLETED || $deal->end_reason === COMPLETED) && $deal->completed_by_type === 'admin'): ?>
                                            <?php
                                                $admin = $deal->completedByAdmin;
                                                $adminRole = $admin?->roles?->first()?->name ?? 'Admin';
                                            ?>
                                            <p class="text-danger italic"><?php echo app('translator')->get('message.completed_by'); ?> <?php echo e($adminRole); ?></p>
                                        <?php endif; ?>

                                        <p class=" italic">
                                            <b><?php echo app('translator')->get('message.updated_on'); ?>:</b>
                                            <?php echo e(dateFormat($deal->status_datetime, DISPLAY_DATE)); ?>

                                        </p>
                                    </div>
                                <?php elseif($deal->deal_status === CANCEL || $deal->end_reason === CANCEL): ?>
                                    <div class="d-flex justify-space-between">
                                        <p class=" italic">
                                            <span class="text-danger">
                                                <?php if($deal->cancel_type != '' && $deal->cancel_type === 'admin'): ?>
                                                    <?php
                                                        $admin = $deal->cancelByAdmin;
                                                        $adminRole = $admin?->roles?->first()?->name ?? 'Admin';
                                                    ?>
                                                    <?php echo e(__('message.cancelled_by')); ?> <?php echo e($adminRole); ?>

                                                <?php elseif($deal->cancel_type != '' && $deal->cancel_type === CUSTOMER): ?>
                                                    <strong><?php echo e(__('message.cancelled_by')); ?> :</strong>
                                                    <?php
                                                        $customer =
                                                            $deal->from_customer_id == $deal->cancel_by
                                                                ? $deal->fromCustomer
                                                                : $deal->toCustomer;
                                                        [$customerLabel, $customerType] = getCustomerType(
                                                            $deal,
                                                            $deal->cancel_by,
                                                        );
                                                    ?>
                                                    <?php echo e($customer->full_name); ?>

                                            </span><span class="text-capitalize text-success">(<?php echo e($customerLabel); ?>)</span>
                                <?php endif; ?>
                                </p>
                                <p class=" italic">
                                    <b><?php echo app('translator')->get('message.updated_on'); ?>:</b>
                                    <?php echo e(dateFormat($deal->status_datetime, DISPLAY_DATE)); ?>

                                </p>
                            </div>
                            <p class="italic text-capitalize"><b>Reason:</b>
                                <?php if($deal->cancel_reason != ''): ?>
                                    <?php echo e($deal->cancel_reason); ?>

                                <?php else: ?>
                                    <?php echo app('translator')->get('message.not_available'); ?>
                                <?php endif; ?>
                            </p>
                            
                        <?php elseif(in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW, DISPUTE_ACCEPTED, DISPUTE_REJECTED]) ||
                                in_array($deal->end_reason, [DISPUTE_ACCEPTED, DISPUTE_REJECTED])): ?>
                            <div class="d-flex justify-space-between">
                                <p class=" italic">
                                    <span class="text-danger">
                                        <?php if($deal->dispute_request_by_type != '' && $deal->dispute_request_by_type === 'admin'): ?>
                                            <?php
                                                $admin = $deal->disputeByAdmin;
                                                $adminRole = $admin?->roles?->first()?->name ?? 'Admin';
                                            ?>
                                            <?php echo app('translator')->get('message.disputed_by'); ?> <?php echo e($adminRole); ?>

                                        <?php elseif($deal->dispute_request_by_type != '' && $deal->dispute_request_by_type === CUSTOMER): ?>
                                            <strong><?php echo app('translator')->get('message.disputed_by'); ?> :</strong>
                                            <?php
                                                $customer =
                                                    $deal->from_customer_id == $deal->dispute_request_by_id
                                                        ? $deal->fromCustomer
                                                        : $deal->toCustomer;
                                                [$customerLabel, $customerType] = getCustomerType(
                                                    $deal,
                                                    $deal->dispute_request_by_id,
                                                );
                                                $customerTag = getCustomerTypeColor(
                                                    $deal,
                                                    $deal->dispute_request_by_id,
                                                );
                                            ?>
                                            <?php echo e($customer->full_name); ?>

                                    </span><span
                                        class="text-uppercase badge <?php echo e($customerTag['bg']); ?>"><?php echo e($customerLabel); ?></span>
                                </p>
                                <?php endif; ?>
                                <p class=" italic">
                                    <b><?php echo app('translator')->get('message.updated_on'); ?>:</b>
                                    <?php echo e(dateFormat($deal->status_datetime, DISPLAY_DATE)); ?>

                                </p>
                            </div>
                            <p class="italic"><b><?php echo app('translator')->get('message.reason'); ?>:</b>
                                <?php if($deal->dispute_reason_id != ''): ?>
                                    <?php
                                        $disputeReason = collect(disputeReasons())->firstWhere(
                                            'key',
                                            $deal->dispute_reason_id,
                                        );
                                    ?>
                                    <?php echo e($disputeReason['value']); ?>

                                <?php else: ?>
                                    <?php echo e($deal->dispute_reason); ?>

                                <?php endif; ?>
                            </p>
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="py-3">
                                        <label class="form-label"><?php echo app('translator')->get('message.created_at'); ?></label>
                                        <p><?php echo e(dateFormat($deal->created_at, DISPLAY_DATETIME)); ?></p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="py-3">
                                        <label class="form-label"><?php echo app('translator')->get('message.title'); ?></label>
                                        <p class="text-capitalize"><?php echo e($deal->deal_title); ?></p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="py-3">
                                        <label class="form-label "><?php echo app('translator')->get('message.amount'); ?></label>
                                        <p> <?php echo e(formatCurrency($deal->deal_amount, $deal->currency_code, 0, 1)); ?>

                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="py-3">
                                        <label class="form-label"><?php echo app('translator')->get('message.created_by'); ?> :</label>
                                        <div class="user-info-thumb  text-dark">
                                            <?php
                                                $fromCustomerTypeClass = getCustomerTypeColor(
                                                    $deal,
                                                    $deal->from_customer_id,
                                                );
                                                $toCustomerTypeClass = getCustomerTypeColor(
                                                    $deal,
                                                    $deal->to_customer_id,
                                                );

                                            ?>
                                            <p class="text-capitalize"><label
                                                    for=""><?php echo e($deal->fromCustomer->full_name); ?></label>
                                                <span class="badge <?php echo e($fromCustomerTypeClass['bg']); ?>">
                                                    <?php echo e(getCustomerType($deal, $deal->from_customer_id)[0]); ?>

                                                </span>
                                                <?php echo deletedCustomer($deal->fromCustomer); ?>

                                            </p>
                                            
                                            <p id="to_customer" class="small-text user-info-thumb">
                                                <i class='bx bx-mobile-alt'></i>
                                                <span>
                                                    <?php echo e($deal->fromCustomer->dial_code); ?>

                                                    <?php echo e($deal->fromCustomer->mobile_number); ?>

                                                </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="py-3">
                                        <label class="form-label"><?php echo app('translator')->get('message.created_for'); ?>: </label>
                                        <div class="user-info-thumb  text-dark">
                                            <p class="text-capitalize"><label
                                                    for=""><?php echo e($deal->toCustomer->full_name); ?></label>
                                                <span class="badge <?php echo e($toCustomerTypeClass['bg']); ?>">
                                                    <?php echo e(getCustomerType($deal, $deal->to_customer_id)[0]); ?>

                                                </span>
                                                <?php echo deletedCustomer($deal->toCustomer); ?>

                                            </p>
                                            
                                            <p id="to_customer" class="small-text user-info-thumb">
                                                <i class='bx bx-mobile-alt'></i>
                                                <span>
                                                    <?php echo e($deal->toCustomer->dial_code); ?>

                                                    <?php echo e($deal->toCustomer->mobile_number); ?>

                                                </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if($deal->images && $deal->images->count() > 0): ?>
                                <label class="form-label"><?php echo app('translator')->get('message.deal_item_images'); ?></label>
                                <div class="row">
                                    <?php $__currentLoopData = $deal->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-4 pt-3">

                                            <div>
                                                <a data-fancybox="gallery " class="activity-proof shdw"
                                                    href="<?php echo e(asset(DEAL_IMAGES . '/' . $image->image)); ?>" target="_blank">
                                                    <img class="proof-img img-fluid"
                                                        src="<?php echo e(asset(DEAL_IMAGES . '/' . $image->image)); ?>"
                                                        alt="">
                                                </a>
                                            </div>


                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                </div>
                            <?php endif; ?>
                            
                            <?php if(!empty($deal->payment_proof) || !empty($deal->shipping_proof)): ?>
                                <div class="row">
                                    <?php if(!empty($deal->payment_proof)): ?>
                                        <div class="col-md-6 pt-3">
                                            <label class="form-label"><?php echo app('translator')->get('message.payment_proof'); ?></label>
                                            <div>
                                                <a data-fancybox="gallery " class="activity-proof shdw"
                                                    href="<?php echo e(asset(PAYMENT_PROOF_PATH . '/' . $deal->payment_proof)); ?>"
                                                    target="_blank">
                                                    <img class="proof-img img-fluid"
                                                        src="<?php echo e(asset(PAYMENT_PROOF_PATH . '/' . $deal->payment_proof)); ?>"
                                                        alt="">
                                                </a>
                                            </div>
                                            <?php
                                                if ($deal->payment_status == ACCEPTED) {
                                                    $bg = 'bg-success';
                                                } elseif ($deal->payment_status == 'rejected') {
                                                    $bg = 'bg-danger';
                                                } elseif ($deal->payment_status == PENDING) {
                                                    $bg = 'bg-warning';
                                                }
                                            ?>
                                            <span
                                                class="badge <?php echo e($bg); ?> start-0 m-2"><?php echo e($deal->payment_status); ?></span>
                                            <?php if($deal->payment_proof && $deal->deal_status == ACCEPTED): ?>
                                                <?php if($deal->payment_status == PENDING): ?>
                                                    
                                                    <div class="update-payment-proof-status">
                                                        <h6 class="mb-0 mt-2">Payment Proof Status</h6>
                                                        <form
                                                            action="<?php echo e(route('admin.deals.updatePaymentDocumentStatus', $deal->id)); ?>"
                                                            method="post" class="ajaxSubmit mt-3">
                                                            <?php echo csrf_field(); ?>
                                                            <select name="payment_proof_statuses"
                                                                id="payment_proof_statuses" class="form-select">
                                                                <option value="">Select</option>
                                                                <option value="<?php echo e(ACCEPTED); ?>">Accepted</option>
                                                                <option value="<?php echo e(REJECTED); ?>">Rejected</option>
                                                            </select>
                                                            <textarea class="form-control mt-2" placeholder="Reason (Optional)" name="payment_tarea" id="payment_tarea"
                                                                rows="2"></textarea>
                                                            <button type="submit"
                                                                class="mt-2 btn btn-primary btn-sm">Submit</button>
                                                        </form>

                                                    </div>
                                                <?php endif; ?>

                                                <div class="mt-2">
                                                    <?php if(
                                                        $deal->latestPaymentRejection?->reason &&
                                                            $deal->deal_status == ACCEPTED &&
                                                            !in_array($deal->payment_status, [ACCEPTED])): ?>
                                                        <strong>Reason:</strong>
                                                        <?php echo e($deal->latestPaymentRejection?->reason); ?> <br>
                                                        <small>
                                                            By <?php echo e($deal->latestPaymentRejection?->admin->name); ?>

                                                            on
                                                            <?php echo e($deal->latestPaymentRejection?->created_at?->format('d M Y H:i')); ?>

                                                        </small>
                                                    <?php endif; ?>


                                                </div>

                                            <?php endif; ?>
                                            
                                            <?php if($deal->paymentRejections->count() > 0): ?>
                                                <div class="mt-3">
                                                    <strong>Rejection History
                                                        (<?php echo e($deal->paymentRejections?->count()); ?>)</strong>
                                                    <ul>
                                                        <?php $__currentLoopData = $deal->paymentRejections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $rejection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li>
                                                                Attempt <?php echo e($index + 1); ?>:
                                                                <?php echo e($rejection?->created_at->format('d M Y H:i')); ?>

                                                                (Reason: <?php echo e($rejection?->reason ?? 'N/A'); ?>)
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if(!empty($deal->shipping_proof)): ?>
                                        <div class="col-md-6 pt-3">
                                            <label class="form-label"><?php echo app('translator')->get('message.shipping_proof'); ?></label>
                                            <div>
                                                <a data-fancybox="gallery " class="activity-proof shdw"
                                                    href="<?php echo e(asset(SHIPPING_PROOF_PATH . '/' . $deal->shipping_proof)); ?>"
                                                    target="_blank">
                                                    <img class="proof-img img-fluid"
                                                        src="<?php echo e(asset(SHIPPING_PROOF_PATH . '/' . $deal->shipping_proof)); ?>"
                                                        alt="">
                                                </a>
                                            </div>
                                            <?php
                                                if ($deal->shipping_status == ACCEPTED) {
                                                    $bg = 'bg-success';
                                                } elseif ($deal->shipping_status == 'rejected') {
                                                    $bg = 'bg-danger';
                                                } elseif ($deal->shipping_status == PENDING) {
                                                    $bg = 'bg-warning';
                                                }
                                            ?>
                                            <span
                                                class="badge <?php echo e($bg); ?> start-0 m-2"><?php echo e($deal->shipping_status); ?></span>
                                            <?php if($deal->shipping_proof && $deal->deal_status == ACCEPTED): ?>
                                                <?php if($deal->shipping_status == PENDING): ?>
                                                    
                                                    <div class="update-shipping-proof-status">
                                                        <h6 class="mb-0 mt-2">Shipping Proof Status</h6>
                                                        <form
                                                            action="<?php echo e(route('admin.deals.updateShippingDocumentStatus', $deal->id)); ?>"
                                                            method="post" class="ajaxSubmit mt-3">
                                                            <?php echo csrf_field(); ?>
                                                            <select name="shipping_proof_statuses"
                                                                id="shipping_proof_statuses" class="form-select">
                                                                <option value="">Select</option>
                                                                <option value="<?php echo e(ACCEPTED); ?>">Accepted</option>
                                                                <option value="<?php echo e(REJECTED); ?>">Rejected</option>
                                                            </select>
                                                            <textarea class="form-control mt-2" placeholder="Reason (Optional)" name="shipping_tarea" id="shipping_tarea"
                                                                rows="2"></textarea>
                                                            <button type="submit"
                                                                class="mt-2 btn btn-primary btn-sm">Submit</button>
                                                        </form>

                                                    </div>
                                                <?php endif; ?>

                                                <div class="mt-2">
                                                    <?php if(
                                                        $deal->latestShippingRejection?->reason &&
                                                            $deal->deal_status == ACCEPTED &&
                                                            !in_array($deal->shipping_status, [ACCEPTED])): ?>
                                                        <strong>Reason:</strong>
                                                        <?php echo e($deal->latestShippingRejection?->reason); ?> <br>
                                                        <small>
                                                            By <?php echo e($deal->latestShippingRejection?->admin->name); ?>

                                                            on
                                                            <?php echo e($deal->latestShippingRejection?->created_at?->format('d M Y H:i')); ?>

                                                        </small>
                                                    <?php endif; ?>


                                                </div>

                                            <?php endif; ?>
                                            
                                            <?php if($deal->shippingRejections->count() > 0): ?>
                                                <div class="mt-3">
                                                    <strong>Rejection History
                                                        (<?php echo e($deal->shippingRejections?->count()); ?>)</strong>
                                                    <ul>
                                                        <?php $__currentLoopData = $deal->shippingRejections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $rejection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li>
                                                                Attempt <?php echo e($index + 1); ?>:
                                                                <?php echo e($rejection?->created_at->format('d M Y H:i')); ?>

                                                                (Reason: <?php echo e($rejection?->reason ?? 'N/A'); ?>)
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            
                            <?php if(in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW, DISPUTE_ACCEPTED, DISPUTE_REJECTED])): ?>
                                <?php if($deal->disputeDocs->isNotEmpty()): ?>
                                    <div id="dispute-docs-section">
                                        <hr>
                                        <h5><?php echo app('translator')->get('message.dispute_documents'); ?></h5>
                                        <?php if($sellerDisputeDocs->isNotEmpty()): ?>
                                            <h6 class="seller-color mb-0">By Seller:</h6>
                                            <div class="row">
                                                <?php $__currentLoopData = $sellerDisputeDocs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disputeDoc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-lg-2 col-md-4 col-sm-6 py-3">
                                                        <?php if($disputeDoc->file_type == 'image'): ?>
                                                            <a data-fancybox="gallery" class="shdw"
                                                                href="<?php echo e(asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path)); ?>"
                                                                target="_blank">
                                                                <img width="" class="media-item"
                                                                    src="<?php echo e(asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path)); ?>"
                                                                    alt="">
                                                            </a>
                                                        <?php elseif($disputeDoc->file_type == 'doc'): ?>
                                                            <a target="_blank" class="shdw"
                                                                href="<?php echo e(asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path)); ?>">
                                                                <img width="" class="media-item"
                                                                    src="<?php echo e(asset(DISPUTED_DOCS_PATH . '/document.png')); ?>"
                                                                    alt="">
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if($buyerDisputeDocs->isNotEmpty()): ?>
                                            <h6 class="buyer-color mb-0">By Buyer:</h6>
                                            <div class="row">
                                                <?php $__currentLoopData = $buyerDisputeDocs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disputeDoc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-lg-2 col-md-4 col-sm-6 py-3">
                                                        <?php if($disputeDoc->file_type == 'image'): ?>
                                                            <a data-fancybox="gallery" class="shdw"
                                                                href="<?php echo e(asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path)); ?>"
                                                                target="_blank">
                                                                <img width="" class="media-item"
                                                                    src="<?php echo e(asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path)); ?>"
                                                                    alt="">
                                                            </a>
                                                        <?php elseif($disputeDoc->file_type == 'doc'): ?>
                                                            <a target="_blank" class="shdw"
                                                                href="<?php echo e(asset(DISPUTED_DOCS_PATH . '/' . $disputeDoc->file_path)); ?>">
                                                                <img width="" class="media-item"
                                                                    src="<?php echo e(asset(DISPUTED_DOCS_PATH . '/document.png')); ?>"
                                                                    alt="">
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>

                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
                <div class="col-md-5">
                    <div class="card mb-2">
                        <div class="card-body ">
                            <h5><?php echo app('translator')->get('message.amount_details'); ?> :</h5>
                            
                            <?php
                                $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
                            ?>
                            <h6 style = "color:#<?php echo e($paymentStatusResult['color']); ?>">
                                <i class='bx <?php echo e($paymentStatusResult['icon']); ?>'></i>
                                <?php echo e($paymentStatusResult['payment_status']); ?>

                            </h6>

                            <div class="payemnt-status">
                                <h6></h6>
                            </div>
                            <div class="d-flex">
                                <div class="col-sm-6"><?php echo app('translator')->get('message.deal_amount'); ?> :</div>
                                <div class="col-sm-6">
                                    <?php echo e(formatCurrency($deal->deal_amount, $deal->currency_code, 0, 1)); ?></div>
                            </div>
                            <div class="d-flex">
                                <div class="col-sm-6"><?php echo app('translator')->get('message.transfer_fees'); ?>:</div>
                                <div class="col-sm-6">
                                    <?php echo e(formatCurrency($deal->admin_earnings, $deal->currency_code, 0, 1) . ' (' . $deal->transfer_fees_in_percent . '%)'); ?>

                                </div>
                            </div>
                            <hr>
                            <div class="d-flex">
                                <div class="col-sm-6"><?php echo app('translator')->get('message.total_deal_amount'); ?>:</div>
                                <div class="col-sm-6">
                                    <?php echo e(formatCurrency($deal->total_deal_Amount, $deal->currency_code, 0, 1)); ?>


                                </div>
                            </div>
                            <?php if(in_array($deal->deal_status, [PENDING, ACCEPTED, TRANSIT, DELIVERED])): ?>
                                <div class="d-flex mt-4">
                                    <div class="col-sm-6"><?php echo app('translator')->get('message.amount_to_be_released'); ?> :</div>
                                    <div class="col-sm-6">
                                        <span
                                            id="actualAmountDisplay"><?php echo e(formatCurrency($deal->deal_amount, $deal->currency_code, 0, 1)); ?></span>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if($deal->is_release == 1): ?>
                                <div class="d-flex mt-2">
                                    <div class="col-sm-6"><?php echo app('translator')->get('message.released_amount'); ?>:</div>
                                    <div class="col-sm-6">
                                        <span><?php echo e(formatCurrency($deal->release_amount, $deal->currency_code, 0, 1)); ?></span>
                                    </div>
                                </div>
                                <div class="d-flex">

                                    </span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if(
                                $deal->is_paid == 0 &&
                                    $deal->deal_status == ACCEPTED &&
                                    $deal->payment_proof &&
                                    file_exists(PAYMENT_PROOF_PATH . '/' . $deal->payment_proof) &&
                                    $deal->payment_status == ACCEPTED): ?>
                                <div class="mark-paid">
                                    <form action="<?php echo e(route('admin.deal.markPaid', $deal->id)); ?> " method="POST"
                                        class="ajaxSubmit ">
                                        <?php echo csrf_field(); ?>
                                        <button
                                            class="btn
                                        btn-primary mark-paid-btn"
                                            id="mark-paid-btn" onclick="markPaid(<?php echo e($deal->id); ?>)">
                                            <i class='bx bx-check-circle'></i>
                                            <?php echo app('translator')->get('message.mark_paid'); ?></button>
                                    </form>

                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if(in_array($deal->deal_status, [DISPUTE_ACCEPTED, DISPUTE_REJECTED, COMPLETED, CANCEL]) &&
                                $deal->is_release == 0 &&
                                $deal->is_hold == 1 &&
                                $deal->is_paid == 1): ?>
                            <div class="d-flex
                                        padding-x15 mb-2 ">
                                <div class="col-sm-6"><?php echo app('translator')->get('message.amount_to_be_released'); ?> :</div>
                                <div class="col-sm-6"><?php echo e(CURRENCY); ?>

                                    <span id="actualAmountDisplay"><?php echo e($deal->deal_amount); ?></span>
                                </div>
                            </div>
                            <?php if($authUser->hasPermissionTo('amount release - deal detail') || $authUser->id == 1): ?>
                                <form action="<?php echo e(route('admin.dealAmount.update', $deal->id)); ?>"
                                    class="padding-x15 ajaxSubmit" id="ajaxSubmit1" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mt-2">
                                        <div class="col-sm-12">



                                            <?php if($deal->is_hold == 1 && in_array($deal->deal_status, [CANCEL, COMPLETED])): ?>
                                                <?php if($deal->is_hold == 1 && in_array($deal->deal_status, [CANCEL])): ?>
                                                    <hr>
                                                    <div class="d-flex mt-2">
                                                        <div class="col-sm-6"><?php echo app('translator')->get('message.amount_released_to'); ?>:</div>
                                                        <div class="col-sm-6">
                                                            <select name="amount_released_to" required
                                                                id="amount_released_to" class="select2">
                                                                <option value=""><?php echo app('translator')->get('message.select'); ?></option>

                                                                <option value="<?php echo e($deal->from_customer_id); ?>"
                                                                    <?php if(!@empty($deal->fromCustomer->deleted_at)): ?> disabled <?php endif; ?>>
                                                                    <?php echo e($fromCustomerPrefix); ?>

                                                                    <?php if(!empty($deal->fromCustomer->deleted_at)): ?>
                                                                        (Deleted)
                                                                    <?php endif; ?>
                                                                </option>
                                                                <option value="<?php echo e($deal->to_customer_id); ?>"
                                                                    <?php if(!@empty($deal->toCustomer->deleted_at)): ?> disabled <?php endif; ?>>
                                                                    <?php echo e($toCustomerPrefix); ?>

                                                                    <?php if(!empty($deal->toCustomer->deleted_at)): ?>
                                                                        (Deleted)
                                                                    <?php endif; ?>
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                <?php endif; ?>
                                                <?php if($deal->is_hold == 1 && in_array($deal->deal_status, [COMPLETED])): ?>
                                                    <div class="row">


                                                        <div class="col-sm-6">

                                                            <?php echo app('translator')->get('message.amount_will_release_to'); ?>:


                                                        </div>
                                                        <div class="col-sm-6 text-capitalize px-0">
                                                            <?php echo e($releaseToSeller); ?>

                                                        </div>
                                                        <input type="hidden" name="completed_relase_to"
                                                            value="<?php echo e($releaseToSellerId); ?>">

                                                    </div>
                                                <?php endif; ?>
                                                

                                                <div class="submit-btn-outer my-3">
                                                    <button type="submit"
                                                        class="btn btn-primary"><?php echo app('translator')->get('message.release_amount'); ?></button>
                                                </div>
                                            <?php endif; ?>
                                            <?php if($deal->is_hold == 1 && in_array($deal->deal_status, [DISPUTE_ACCEPTED, DISPUTE_REJECTED])): ?>
                                                <div class="row">


                                                    <div class="col-sm-6">
                                                        <?php if($deal->is_release == 1): ?>
                                                            <?php echo app('translator')->get('message.amount_released_to'); ?>:
                                                        <?php else: ?>
                                                            <?php echo app('translator')->get('message.amount_will_release_to'); ?>:
                                                        <?php endif; ?>

                                                    </div>
                                                    <div class="col-sm-6 text-capitalize px-0">
                                                        <?php echo e($releaseToCustomerInfo); ?>

                                                    </div>
                                                    <input type="hidden" name="disputed_relase_to"
                                                        value="<?php echo e($releaseToCustomerId); ?>">

                                                </div>
                                                <div class="submit-btn-outer my-3">
                                                    <button type="submit"
                                                        class="btn btn-primary"><?php echo app('translator')->get('message.release_amount'); ?></button>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </form>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <?php if($authUser->hasPermissionTo('update status - deal detail') || $authUser->id == 1): ?>
                        <?php if(!in_array($deal->deal_status, [COMPLETED, CANCEL, CLOSED, DISPUTE_ACCEPTED, DISPUTE_REJECTED])): ?>


                            <div class="card mt-2 mt-2">
                                <div class="card-body">
                                    <form action="<?php echo e(route('admin.deals.updateStatus', $deal->id)); ?>" class="ajaxSubmit"
                                        Id="ajaxSubmit2" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="_method" value="PUT">
                                        <div class="py-3">
                                            <label class="form-label"
                                                for="basic-default-password"><?php echo app('translator')->get('message.status'); ?></label>
                                            <select name="deal_status" id="deal_status" class="form-select" required>
                                                <option value="">
                                                    <?php echo e(__('message.select_status')); ?>

                                                </option>
                                                <?php $__currentLoopData = dealStatusSelection(false, '', $deal->is_hold, $deal->is_paid, $deal->deal_status, $deal->shipping_status, $deal->shipping_proof); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($key !== $deal->deal_status): ?>
                                                        <option value="<?php echo e($key); ?>">
                                                            <?php echo e(ucfirst($value)); ?>

                                                        </option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                        </div>
                                        
                                        <?php if($deal->deal_status == 'cancel' || $deal->end_reason == 'cancel'): ?>
                                            <?php if($deal->cancel_reason): ?>
                                                <p class="text-capitalize"><?php echo e($deal->cancel_reason); ?></p>
                                            <?php else: ?>
                                                <p><?php echo app('translator')->get('message.no_cancellation_reason_available'); ?></p>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <!-- cancel reason dialog box -->
                                        <div id="cancel-section" class="cancel-section disp-none">
                                            <label class="form-label"
                                                for="basic-default-reason"><?php echo app('translator')->get('message.cancel_reason'); ?></label>
                                            <span class="small-text text-danger">(<?php echo app('translator')->get('message.required'); ?>)</span>
                                            <textarea name="cancel_reason" id="cancel_reason" class="form-control" rows="2"></textarea>
                                        </div>
                                        <!-- dispute reason dialog box -->
                                        <div id="dispute-section" class="dispute-section disp-none">
                                            <label class="form-label"
                                                for="basic-default-dispute"><?php echo app('translator')->get('message.dispute_reason'); ?></label>
                                            <span class="small-text text-danger">(<?php echo app('translator')->get('message.required'); ?>)</span>
                                            <textarea name="dispute_reason" id="dispute_reason" class="form-control" rows="2"></textarea>
                                        </div>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="submit-btn-outer my-3">
                                                    <button type="submit"
                                                        class="btn btn-primary"><?php echo app('translator')->get('message.update_status'); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if($authUser->hasPermissionTo('timeline history - deal detail') || $authUser->id == 1): ?>
                        
                        <div class="card mt-2">
                            <div class="card-body">
                                <h5><?php echo app('translator')->get('message.display_deal_status_timeline'); ?></h5>
                                

                                <ul class="timeline">
                                    <?php $__currentLoopData = $dealStatusHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dealStatusHistory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $status = displayStatusHistory($dealStatusHistory->status);
                                        ?>
                                        <li class="timeline-item">
                                            <div class="timeline-dot"></div>
                                            <div class="timeline-content">
                                                <strong><?php echo e($status['value']); ?></strong>
                                                <small class="text-muted d-block">
                                                    <?php echo e(\Carbon\Carbon::parse($dealStatusHistory->created_at)->format(DISPLAY_DATETIME)); ?>

                                                </small>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="conversation pt-3">
                <?php if($messages->isNotEmpty() || !in_array($deal->deal_status, [DISPUTE_ACCEPTED, DISPUTE_REJECTED])): ?>
                    <?php if($authUser->hasPermissionTo('conversation - dispute deals') || $authUser->id == 1): ?>
                        <?php if(in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW, DISPUTE_ACCEPTED, DISPUTE_REJECTED])): ?>
                            <h5><?php echo app('translator')->get('message.dispute_conversation'); ?></h5>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="card">
                                        <div class="card-header bg-primary text-white mb-3">
                                            <h6 class="mb-0 text-white"><?php echo app('translator')->get('message.conversation_to_buyer'); ?> :

                                            </h6>
                                        </div>
                                        
                                        <div id="buyer-message-list" class="card-body mb-3 mesg-card-height"
                                            style=" overflow-y: auto;">
                                            <?php echo $__env->make('admin.deal.conversation', [
                                                'messages' => $buyerMessages,
                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                        <?php if(in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW])): ?>
                                            <div class="card-footer">
                                                <!-- Admin Reply Form -->
                                                <form action="<?php echo e(route('admin.dispute.reply')); ?>" class="ajaxSubmit"
                                                    id="ajaxSubmit3" enctype="multipart/form-data" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="deal_id" id="deal_id"
                                                        value="<?php echo e($deal->id); ?>">
                                                    <input type="hidden" name="receiver_id"
                                                        value="<?php echo e($buyerId); ?>">
                                                    <input type="hidden" name="receiver_type" value="customer">
                                                    <input type="hidden" name="get_messages_url" id="get_messages_url"
                                                        value="<?php echo e(route('admin.deal.getMessages', $deal->id)); ?>">
                                                    <div class="input-group">
                                                        <textarea name="message" id="message-input-buyer" class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            placeholder="Type your response..."><?php echo e(old('message')); ?></textarea>
                                                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <p class="invalid-feedback"><?php echo e($message); ?></p>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        <button type="submit"
                                                            class="btn btn-primary"><?php echo app('translator')->get('message.send'); ?></button>
                                                    </div>
                                                </form>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="card">
                                        <div class="card-header bg-primary text-white mb-3">
                                            <h6 class="mb-0 text-white"><?php echo app('translator')->get('message.conversation_to_seller'); ?> :

                                            </h6>
                                        </div>
                                        
                                        <div id="seller-message-list" class="card-body mb-3 mesg-card-height"
                                            style=" overflow-y: auto;">
                                            <?php echo $__env->make('admin.deal.conversation', [
                                                'messages' => $sellerMessages,
                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                        <?php if(in_array($deal->deal_status, [ON_DISPUTE, DISPUTE_UNDER_REVIEW])): ?>
                                            <div class="card-footer">
                                                <!-- Admin Reply Form -->
                                                <form action="<?php echo e(route('admin.dispute.reply')); ?>" class="ajaxSubmit"
                                                    id="ajaxSubmit3" enctype="multipart/form-data" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="deal_id" id="deal_id"
                                                        value="<?php echo e($deal->id); ?>">
                                                    <input type="hidden" name="receiver_id"
                                                        value="<?php echo e($sellerId); ?>">
                                                    <input type="hidden" name="receiver_type" value="customer">
                                                    <input type="hidden" name="get_messages_url" id="get_messages_url"
                                                        value="<?php echo e(route('admin.deal.getMessages', $deal->id)); ?>">
                                                    <div class="input-group">
                                                        <textarea name="message" id="message-input-seller" class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            placeholder="Type your response..."><?php echo e(old('message')); ?></textarea>
                                                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <p class="invalid-feedback"><?php echo e($message); ?></p>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        <button type="submit"
                                                            class="btn btn-primary"><?php echo app('translator')->get('message.send'); ?></button>
                                                    </div>
                                                </form>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        //display cancel reason
        $("#deal_status").on("change", function() {
            let selectedStatus = $(this).val();
            //alert("Selected Status: " + selectedStatus);
            let CANCEL = <?php echo json_encode(CANCEL, 15, 512) ?>;
            let ON_DISPUTE = <?php echo json_encode(ON_DISPUTE, 15, 512) ?>;

            //cancel
            if (selectedStatus.trim() === CANCEL) {
                $("#cancel-section").show();
                $('#cancel_reason').attr('required', true);
                //alert()
            } else {
                $("#cancel-section").slideUp();
                $('#cancel_reason').removeAttr('required');
            }

            //dispute
            if (selectedStatus.trim() === ON_DISPUTE) {
                $("#dispute-section").show();
                $('#dispute_reason').attr('required', true);
                //alert()
            } else {
                $("#dispute-section").slideUp();
                $('#dispute_reason').removeAttr('required');
            }
        });

        //display dispute reason

        // Define deal amounts from Laravel


        // Function to update the amount display
        var dealAmount = <?php echo e($deal->deal_amount); ?>;
        // var releaseAmount = <?php echo e($deal->release_amount); ?>;

        function updateAmount() {
            if ($('#toggleServiceTax').is(':checked')) {

                $('#actualAmountDisplay').text(releaseAmount);
            } else {
                $('#actualAmountDisplay').text(dealAmount);
            }
        }

        // Call function on checkbox change
        $('#toggleServiceTax').change(function() {
            updateAmount();
        });

        // Call function on page load to set initial value
        if ($('#toggleServiceTax').length > 0) {
            updateAmount();
        }
        Fancybox.bind("[data-fancybox]", {
            Toolbar: true,
            Thumbs: true,
            loop: true,
        });
        //check if payment proof documnet is rejected then display reason text area 
        $("#payment_proof_statuses").on("change", function() {
            let selectedStatus = $(this).val();
            //alert("Selected Status: " + selectedStatus);
            let REJECTED = <?php echo json_encode(REJECTED, 15, 512) ?>;

            //cancel
            if (selectedStatus.trim() === REJECTED) {
                $("#payment_tarea").show();
                //$('#cancel_reason').attr('required', true);

            } else {
                $("#payment_tarea").hide();
                //$('#cancel_reason').removeAttr('required');
            }


        });
        //check if shipping proof documnet is rejected then display reason text area 
        $("#shipping_proof_statuses").on("change", function() {
            let selectedStatus = $(this).val();
            //alert("Selected Status: " + selectedStatus);
            let REJECTED = <?php echo json_encode(REJECTED, 15, 512) ?>;

            //cancel
            if (selectedStatus.trim() === REJECTED) {
                $("#shipping_tarea").show();
                //$('#cancel_reason').attr('required', true);

            } else {
                $("#shipping_tarea").hide();
                //$('#cancel_reason').removeAttr('required');
            }


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/deal/resources/views/admin/deal/show.blade.php ENDPATH**/ ?>