
<?php $__env->startSection('title', 'Users List'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">

        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row">
                <div class="col-12">
                    <!-- Hoverable Table rows -->
                    <div class="card px-4">

                        <?php if(session('success')): ?>
                            <div class="alert alert-success pt-2">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger pt-2">
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>



                        <div class="mt-5 d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark"><?php echo app('translator')->get('message.users_list'); ?></h3>
                            <a href="<?php echo e(route('admin.user.create')); ?>" class="btn btn-primary"><i
                                    class='bx bx-plus-circle'></i><?php echo app('translator')->get('message.create_user'); ?></a>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div id="pagination-table">
                                    <table class="dataTable dt-responsive table table-hover display align-middle mb-0">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <?php echo app('translator')->get('message.customer_list_register'); ?>
                                                    </span></th>
                                                <th>
                                                    <?php echo app('translator')->get('message.name'); ?>
                                                    </span></th>

                                                <th>
                                                    <?php echo app('translator')->get('message.assigned_role'); ?>
                                                    </span></th>
                                                <th>
                                                    <?php echo app('translator')->get('message.customer_list_email'); ?>
                                                    </span></th>
                                                <th>
                                                    <?php echo app('translator')->get('message.customer_list_mobile'); ?>
                                                    </span></th>
                                                <th>
                                                    <?php echo app('translator')->get('message.status'); ?>
                                                    </span></th>
                                                <th><?php echo app('translator')->get('message.actions'); ?></span></th>
                                            </tr>
                                        </thead>
                                        <?php if(isset($admins) && count($admins) > 0): ?>
                                            <tbody class="table-border-bottom-0">

                                                <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>

                                                        <td class="text-capitalize">
                                                            <?php echo e(dateFormat($user->created_at, DISPLAY_DATE)); ?></td>
                                                        <td class="text-capitalize"><?php echo e($user->name); ?></td>
                                                        <td class="text-capitalize">
                                                            <?php echo e($user->roles->pluck('name')->implode(', ')); ?>


                                                        </td>
                                                        <td class=""><?php echo e($user->email); ?></td>
                                                        <td class="text-capitalize">

                                                            <?php echo e($user->dial_code); ?>

                                                            <?php echo e($user->mobile_number); ?>

                                                        </td>
                                                        <td class="text-capitalize">
                                                            <?php echo statusText($user->status); ?>

                                                        </td>
                                                        <td>



                                                            <div class="d-flex">


                                                                <a class="btn-role"
                                                                    href="<?php echo e(route('admin.user.edit', $user->id)); ?>">
                                                                    <i class="bx bx-edit"></i></a>


                                                                <button class="delete-btn btn-role"
                                                                    data-url="<?php echo e(route('admin.user.destroy', $user->id)); ?>"
                                                                    data-id="<?php echo e($user->id); ?>"><i
                                                                        class="bx bx-trash me-1"></i>
                                                                </button>


                                                            </div>






                                                        </td>
                                                    </tr>



                                            </tbody>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </table>

                                </div>
                            </div>
                        </div>

                    </div>
                    <!--/ Hoverable Table rows -->
                </div>
            </div>

        </div>
        <!-- / Content -->
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/deal/resources/views/admin/users/index.blade.php ENDPATH**/ ?>