<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- Hoverable Table rows -->
            <div class="card px-4">

                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session('error')): ?>
                    <div class="alert alert-danger">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>

                <div class="row mt-4 mb-4">
                    <div class="col-sm-4">
                        <h3 class=" text-dark"><?php echo app('translator')->get('message.cancelled_deal_list'); ?></h3>
                    </div>



                    <div class="col-sm-8 ms-auto">

                        <div class="d-flex gap-3">
                            <?php if($deals->total() > 0): ?>
                                <a href="<?php echo e(route('admin.deals.exportCancel', request()->query())); ?>">
                                    <img title="Export Report" width="30"
                                        src="<?php echo e(asset('admin-assets/img/icons/download-excel-file.png')); ?>"
                                        alt="Export Report">
                                </a>
                            <?php endif; ?>
                            <div class="col-sm-4">

                                <select class="select2" name="payment_status" id="payment_status">
                                    <option value=""><?php echo app('translator')->get('message.select_payment_status'); ?></option>

                                    <?php $__currentLoopData = closedDealStatuses(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </div>
                            <div class="input-group input-group-merge">
                                <span id="basic-icon-default-fullname2" class="input-group-text">
                                    <i class="bx bx-search-alt"></i>
                                </span>

                                <input type="text" id="search" class="form-control" name="keyword"
                                    placeholder="Search">
                            </div>

                            <button type="button" class="btn btn-icon btn-info" data-bs-toggle="offcanvas"
                                href="#filterPanel" role="button" aria-controls="filterPanel">
                                <i class="bx bx-filter"></i>
                            </button>
                        </div>

                        <div class="offcanvas offcanvas-end" tabindex="-1" id="filterPanel" aria-labelledby="filterPanel"
                            aria-modal="true" role="dialog">
                            <div class="offcanvas-header border-bottom">
                                <h5 class="offcanvas-title text-uppercase" id="offcanvasRightLabel">
                                    <?php echo app('translator')->get('message.apply_filter'); ?>
                                </h5>
                                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                                    aria-label="Close"></button>
                            </div>

                            <div class="offcanvas-body p-0">
                                <div class="acitivity-timeline p-4">
                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label"><?php echo app('translator')->get('message.per_page'); ?></label>
                                            <select id="per_page" name="" class="form-select w-auto select2">
                                                <?php $__currentLoopData = perPage(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <?php if(request()->routeIs('admin.deals.cancelled')): ?>
                                            <input type="hidden" id="pageUrl"
                                                value="<?php echo e(route('admin.deals.cancelled')); ?>">
                                        <?php endif; ?>




                                        <div class="col-md-12 mb-3">
                                            <label class="form-label"><?php echo app('translator')->get('message.deal_type'); ?></label>
                                            <select id="deal_type_filter" class="form-select w-auto select2"
                                                name="deal_type">
                                                <?php $__currentLoopData = dealTypeFilter(true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </select>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label"><?php echo app('translator')->get('message.currency_type'); ?></label>
                                            <select id="currency_type_filter" class="form-select w-auto select2"
                                                name="currency_type">
                                                <?php $__currentLoopData = currencyTypeFilter(true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </select>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label"><?php echo app('translator')->get('message.from'); ?></label>
                                            <input class="form-control" type="date" name="date-range" id="date">
                                        </div>




                                        <div class="col-md-12 mt-2">
                                            <button id="applyFilter" type="submit"
                                                class="filter-btn btn btn-info btn-border me-1">
                                                <i class="bx bx-check"></i> <?php echo app('translator')->get('message.apply_filter'); ?></button>
                                            </button>
                                            <a href="" class="btn btn-outline-secondary mt-2">
                                                <i class="bx bx-refresh"></i> <?php echo app('translator')->get('message.clear'); ?>
                                            </a>
                                        </div>



                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div id="pagination-table">
                            <?php echo $__env->make('admin.deal.cancelled.pagination', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>

            </div>
            <!--/ Hoverable Table rows -->
        </div>
        <!-- / Content -->
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/deal/resources/views/admin/deal/cancelled/index.blade.php ENDPATH**/ ?>