<table class="dataTable dt-responsive table table-hover display align-middle mb-0" style="width:100%">
    <thead>
        <tr>

            <th><span style="width: 50px;" class="sortable" data-sort="deal_number" data-order="asc">
                    <?php echo app('translator')->get('message.deal_number'); ?> <i id="sort-icon-deal_number" class="bx bx-sort"></i>
                </span></th>
            <th><span style="width: 100px;" class="sortable" data-sort="created_at" data-order="asc">
                    <?php echo app('translator')->get('message.date'); ?> <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span></th>

            <th><span class="sortable" data-sort="deal_title" data-order="asc">
                    <?php echo app('translator')->get('message.name'); ?> <i id="sort-icon-deal_title" class="bx bx-sort"></i>

                </span></th>

            <th><span style="width: 100px;" class="sortable" data-sort="deal_amount" data-order="asc">
                    <?php echo app('translator')->get('message.amount'); ?> <i id="sort-icon-deal_amount" class="bx bx-sort"></i>

                </span></th>

            



            <th><span style="width: 250px;">

                    <?php echo app('translator')->get('message.buyer_detail'); ?>


                </span></th>
            <th><span style="width: 250px;">
                    <?php echo app('translator')->get('message.seller_detail'); ?>


                </span></th>

            <th><span style="width: 100px;"><?php echo app('translator')->get('message.payment_status'); ?></span></th>




        </tr>
    </thead>
    <?php if(isset($deals) && count($deals) > 0): ?>
        <tbody class="table-border-bottom-0">
            <?php
                $i = !empty($deals) ? pageIndex($deals) : 1;
            ?>
            <?php $__currentLoopData = $deals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr data-href="<?php echo e(route('admin.deal.show', $deal->id)); ?>" class="clickable-row">
                    <td>#<?php echo e($deal->deal_number); ?></td>
                    <td><?php echo e(dateFormat($deal->created_at, DISPLAY_DATETIME)); ?></td>
                    <td class="text-capitalize">
                        <strong><?php echo e($deal->deal_title); ?></strong>
                    </td>

                    <td class="text-capitalize">
                        <strong><?php echo e(formatCurrency($deal->deal_amount, $deal->currency_code, 0, 1)); ?></strong>
                    </td>
                    
                    <td style="width: 15px;">
                        <strong class="buyer-color"><?php echo e($deal->buyer_name); ?></strong>
                        <?php if($deal->buyer_deleted_at): ?>
                            <span class='deleted-cust'><?php echo app('translator')->get('message.customer_deleted'); ?></span>
                        <?php endif; ?>
                        <div class="user-info-thumb">

                            <p id="to_customer" class="small-text user-info-thumb">
                                <i class='bx bx-mobile-alt'></i>
                                <span>
                                    <?php echo e($deal->buyer_dial_code); ?>

                                    <?php echo e($deal->buyer_mobile_number); ?>

                                </span>
                            </p>
                        </div>

                    </td>

                    <td>

                        <strong class="seller-color"><?php echo e($deal->seller_name); ?></strong>
                        <?php if($deal->seller_deleted_at): ?>
                            <span class='deleted-cust'><?php echo app('translator')->get('message.customer_deleted'); ?></span>
                        <?php endif; ?>
                        <div class="user-info-thumb">

                            <p id="to_customer" class="small-text user-info-thumb">
                                <i class='bx bx-mobile-alt'></i>
                                <span>
                                    <?php echo e($deal->seller_dial_code); ?>

                                    <?php echo e($deal->seller_mobile_number); ?>

                                </span>
                            </p>
                        </div>

                    </td>

                    <td>

                        <?php
                            $paymentStatusResult = moneyDepositedStatus($deal, $deal->amount_released_to);
                        ?>
                        <span style = "color:#<?php echo e($paymentStatusResult['color']); ?>">

                            <?php echo e($paymentStatusResult['payment_status']); ?>

                        </span>

                    </td>



                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tfoot>
            <tr>
                <td class="" colspan="7">
                    <div class="mt-2 d-flex mb-2">
                        <div class="col-sm-6">
                            <div class="" id="records"><?php echo pageInfo($deals); ?></div>
                        </div>
                        <div class="col-sm-6">
                            <div class="">
                                <?php echo $deals->links('pagination::bootstrap-4'); ?>

                            </div>
                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>
        </tbody>
    <?php else: ?>
        
    <?php endif; ?>
</table>
<?php /**PATH /home/intellisensetech/public_html/deal/resources/views/admin/deal/cancelled/pagination.blade.php ENDPATH**/ ?>