<?php

use App\Http\Controllers\Admin\AcceptDocumentController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\AllDealsTypesExportController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\CustomerRankController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\DealDocumentController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\RejectDocumentController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Api\DealApiController;
use App\Http\Controllers\Api\InviteController;
use App\Http\Controllers\DealController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\Website\WebsiteController;
use App\Http\Controllers\WebsiteLanguageController;
use App\Services\SMSService;
use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


//website routes
Route::name('website.')->group(function () {
    Route::middleware(['websiteLang'])->group(function () {
        Route::get('/', [WebsiteController::class, 'index'])->name('home');
        Route::get('/about', [WebsiteController::class, 'about'])->name('about');
        Route::get('/download-app', [WebsiteController::class, 'downloadApp'])->name('downloadApp');
        Route::get('/contact', [WebsiteController::class, 'contact'])->name('contact');
        Route::post('/contact-submit', [WebsiteController::class, 'submitContact'])->name('contactSubmit');
        Route::get('/privacy-policy', [WebsiteController::class, 'privacyPolicy'])->name('privacyPolicy');
        Route::get('/terms-conditions', [WebsiteController::class, 'termsConditions'])->name('termsConditions');
    });
});

Route::post('/lang', [LanguageController::class, 'switchLang'])->name('switchLang');
Route::post('/website/lang', [WebsiteLanguageController::class, 'switchLang'])->name('website.switchLang');
Route::get('/clear', [DealApiController::class, 'clear']);

//pages links :
Route::get('/privacy-policy/{lang}', [SettingController::class, 'privacyPolicyWebView'])->name('privacyPolicy');
Route::get('/help/{lang}', [SettingController::class, 'helpWebView'])->name('help');
Route::get('/about-us/{lang}', [SettingController::class, 'aboutUsWebView'])->name('aboutUs');
Route::get('/terms-and-conditions/{lang}', [SettingController::class, 'termsConditionsWebView'])->name('termsConditions');


Route::prefix('admin')->name('admin.')->group(function () {
    Route::middleware('admin.guest')->group(function () {
        Route::get('/', function () {
            return redirect()->route('admin.login');
        });
        Route::get('login', [AdminController::class, 'index'])->name('login');
        //Redirect login
        Route::redirect('admin', 'admin/login');
        Route::post('login', [AdminController::class, 'login_authentication'])->name('login_authentication');
        Route::get('store', [AdminController::class, 'store'])->name('store');
    });

    Route::middleware(['auth:admin', 'admin', 'adminLang'])->group(function () {
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('/earnings-export', [DashboardController::class, 'exportEarnings'])->name('earnings.export');
        Route::post('/logout', [AdminController::class, 'logout'])->name('logout');
        //customer routes
        Route::resource('customer', CustomerController::class);
        Route::post('/send-message', [CustomerController::class, 'sendMessage'])->name('customer.sendMessage'); // ✅ correct

        //Deals routes
        Route::resource('deal', DealController::class);
        //deal status updation
        Route::put('/deal/{id}/status', [DealController::class, 'updateDealStatus'])->name('deals.updateStatus');
        //show deals
        Route::get('/deals/ongoing', [DealController::class, 'onGoingDeals'])->name('deals.ongoing');
        Route::get('/deals/disputed', [DealController::class, 'disputed'])->name('deals.disputed');
        Route::get('/deals/cancelled', [DealController::class, 'cancelled'])->name('deals.cancelled');
        Route::get('/deals/closed', [DealController::class, 'closed'])->name('deals.closed');
        Route::get('/deals/hold-amount', [DealController::class, 'holdAmount'])->name('deals.holdAmount');
        Route::get('/deals/declined', [DealController::class, 'declined'])->name('deals.declined');
        //deal settings (transfer fee)
        Route::get('/setting', [SettingController::class, 'setting'])->name('setting');
        Route::put('/setting/update', [SettingController::class, 'settingUpdate'])->name('setting.update');
        Route::get('/setting/about-us', [SettingController::class, 'aboutUs'])->name('setting.aboutUs');
        Route::put('/setting/about-us/update', [SettingController::class, 'aboutUsUpdate'])->name('setting.aboutUs.update');
        Route::get('/setting/privacy-policy', [SettingController::class, 'privacyPolicy'])->name('setting.privacyPolicy');
        Route::put('/setting/privacy-policy/update', [SettingController::class, 'privacyPolicyUpdate'])->name('setting.privacyPolicy.update');
        Route::get('/setting/help', [SettingController::class, 'help'])->name('setting.help');
        Route::put('/setting/help/update', [SettingController::class, 'helpUpdate'])->name('setting.help.update');
        Route::get('/setting/terms-and-conditions', [SettingController::class, 'termsAndConditions'])->name('setting.termsAndConditions');
        Route::put('/setting/terms-and-conditions/update', [SettingController::class, 'termsAndConditionsUpdate'])->name('setting.termsAndConditions.update');
        Route::get('/setting/bank-details', [SettingController::class, 'bankDetails'])->name('setting.bankDetails');
        Route::put('/setting/bank-details/update', [SettingController::class, 'bankDetailsUpdate'])->name('setting.bankDetails.update');




        Route::put('/deal/release-amount-update/{id}', [DealController::class, 'releaseAmount'])->name('dealAmount.update');
        //profile changes
        Route::get('/profile', [ProfileController::class, 'profile'])->name('profile');
        Route::put('/profile/update/{id}', [profileController::class, 'profileUpdate'])->name('profile.update');
        //change password
        Route::get('/profile/change-password', [profileController::class, 'changePassword'])->name('profile.changePassword');
        Route::put('/profile/change-password-process/{id}', [profileController::class, 'changePasswordProcess'])->name('profile.passwordUpdate');
        Route::resource('banner', BannerController::class);


        //dispute convo
        Route::post('/dispute/reply', [DealController::class, 'submitAdminReplyDisputeConversation'])->name('dispute.reply');
        Route::get('/deal/{id}/messages', [DealController::class, 'getMessages'])->name('deal.getMessages');

        // get chart data via selected year input
        Route::get('get-earnings', [DashboardController::class, 'getEarnings'])->name('dashboard.getEarnings');
        //downoad excel
        Route::post('/earnings/export-report', [DashboardController::class, 'exportReport'])
            ->name('earnings.exportReport');


        Route::get('/recent-menu-count', [DashboardController::class, 'getNewDealsCount'])->name('deals.count');

        //roles and permissions
        Route::get('/permission', [PermissionController::class, 'create'])->name('permission.create');
        Route::post('/permission/store', [PermissionController::class, 'store'])->name('permission.store');
        Route::resource('role', RoleController::class);
        Route::resource('user', UserController::class);
        //get states and cities for edit customer info
        Route::get('get-states/{country_id}', [CustomerController::class, 'getStates']);
        Route::get('get-cities/{State_id}', [CustomerController::class, 'getCities']);
        Route::post('deal/{id}/mark-paid', [DealController::class, 'markPaid'])->name('deal.markPaid');
        //customer ranks system
        Route::get('/customer-rank', [CustomerRankController::class, 'index'])->name('customerRank.index');
        Route::get('/customer-rank/{id}/edit', [CustomerRankController::class, 'edit'])->name('customerRank.edit');
        Route::put('/customer-rank/{id}/update', [CustomerRankController::class, 'update'])->name('customerRank.update');
        //export report of every deal type
        Route::get('deals/export/ongoing/', [AllDealsTypesExportController::class, 'exportOngoingDeals'])->name('deals.exportOngoing');
        Route::get('deals/export/onhold/', [AllDealsTypesExportController::class, 'exportOnholdDeals'])->name('deals.exportOnhold');
        Route::get('deals/export/dispute/', [AllDealsTypesExportController::class, 'exportDisputeDeals'])->name('deals.exportDispute');
        Route::get('deals/export/cancel/', [AllDealsTypesExportController::class, 'exportCancelDeals'])->name('deals.exportCancel');
        Route::get('deals/export/closed/', [AllDealsTypesExportController::class, 'exportClosedDeals'])->name('deals.exportClosed');
        Route::get('deals/export/declined/', [AllDealsTypesExportController::class, 'exportDeclinedDeals'])->name('deals.exportDeclined');

        //reject payment proof
        Route::post('deal/{id}/update-payment-document-status', [DealDocumentController::class, 'updatePaymentDocumentStatus'])->name('deals.updatePaymentDocumentStatus');
        Route::post('deal/{id}/update-shipping-document-status', [DealDocumentController::class, 'updateShippingDocumentStatus'])->name('deals.updateShippingDocumentStatus');
    });
});
Route::get('/invite/{token}', [InviteController::class, 'handleInvite'])->name('invite.show');
