<?php

use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\DealApiController;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\Api\SettingApiController;
use App\Http\Controllers\DealController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->group(function () {
    Route::get('get-profile', [HomeController::class, 'getProfile']);
    Route::post('update-profile', [HomeController::class, 'updateProfile']);
    Route::get('dashboard', [HomeController::class, 'dashboard']);
    Route::post('create-deal', [DealApiController::class, 'createDeal']);
    Route::post('my-deals', [DealApiController::class, 'myDeals']);
    Route::post('deal-detail', [DealApiController::class, 'dealDetail']);
    Route::post('requests-deals', [DealApiController::class, 'requestsDeals']);
    Route::post('request-action', [DealApiController::class, 'requestAction']);
    Route::post('edit-deal-amount', [DealApiController::class, 'editDealAmount']);
    Route::post('get-notifications', [DealApiController::class, 'getNotifications']);
    Route::post('mark-notification-as-read', [DealApiController::class, 'markNotificationAsRead']);
    Route::post('delete-notification', [DealApiController::class, 'deleteNotification']);
    Route::post('update-deal-status', [DealApiController::class, 'updateDealStatus']);
    Route::post('get-dispute-reasons', [DealApiController::class, 'getDisputeReasons']);
    Route::post('submit-dispute', [DealApiController::class, 'submitDispute']);
    Route::post('edit-dispute', [DealApiController::class, 'editDispute']);
    Route::post('delete-dispute-docs', [DealApiController::class, 'deleteDisputeDocs']);
    Route::post('dispute-conversation-send', [DealApiController::class, 'DisputeConversationSend']);
    Route::post('get-dispute-conversation', [DealApiController::class, 'getDisputeConversation']);
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::post('/change-password', [SettingApiController::class, 'changePassword']);
    Route::post('/delete-customer', [SettingApiController::class, 'deleteCustomer']);
    Route::post('/payment-process', [DealApiController::class, 'paymentProcess']);
    Route::post('/submit-payment-proof', [DealApiController::class, 'submitPaymentProof']);
    Route::post('/view-all-deals', [DealApiController::class, 'viewAllDeals']);
    Route::get('/countries', [HomeController::class, 'getCountries']);
    Route::get('/countries/states/{country_id}', [HomeController::class, 'getStateByCountry']);
    Route::get('/state/cities/{state_id}', [HomeController::class, 'getCitiesByState']);
    Route::post('update-profile-image', [HomeController::class, 'updateProfileImage']);
    Route::post('update-bank-details', [HomeController::class, 'updateBankDetails']);
    Route::any('pdf', [DealApiController::class, 'downloadPdf']);
    Route::any('update-fcm-token', [DealApiController::class, 'updateFcmToken']);
    Route::post('update-language', [DealApiController::class, 'updateLanguage']);
    Route::post('get-country-info', [DealApiController::class, 'getCountryInfo']);
    Route::post('dispute_docs_seller', [DealApiController::class, 'disputeDocsSeller']);
    Route::post('submit-shipping-proof', [DealApiController::class, 'submitShippingProof']);
    Route::post('upload-deal-images', [DealApiController::class, 'uploadDealImages']);
});



Route::post('/register', [AuthController::class, 'register']);
Route::post('/verify-mobile-token', [AuthController::class, 'verifyMobileToken']);
Route::post('/login', [AuthController::class, 'login']);

//forgot passords
Route::post('forgot-password', [AuthController::class, 'forgotPassword']);

Route::post('forgot-password-verification', [AuthController::class, 'forgotPasswordVerification']);
Route::post('change-forgot-password', [AuthController::class, 'changeForgotPassword']);
Route::any('test', [AuthController::class, 'test']);
Route::post('/get-pages-links', [SettingApiController::class, 'getPagesLinks']);
//app link to app dev - just for test for app store side
Route::get('app-link', function () {
    return 'Success';
});
