<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title')</title>

    <!-- ========= Bootstrap  ======= -->
    <link href="{{ asset('website-assets/css/bootstrap.min.css') }}" rel="stylesheet">

    <!-- ========= Custom  ======= -->
    <link href="{{ asset('website-assets/css/style.css') }}" rel="stylesheet">

    <!-- ========= Responsive  ======= -->
    <link href="{{ asset('website-assets/css/responsive.css') }}" rel="stylesheet">

    <!-- ========= Font Awesome  ======= -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" rel="stylesheet">

    <!-- ========= AOS Animation ======= -->
    <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css">

    <!-- ========= Fav icon ======= -->
    <link rel="icon" href="{{ asset('website-assets/img/favicon.ico') }}" type="image/x-icon">

</head>

<body>

    <!-- ========= Top Div  ======= -->
    <section id="top-div">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-sm-6">
                    <div class="welcome-text">
                        <p>@lang('website.home.welcome') </p>
                    </div>
                </div>
                <div class="col-lg-6 col-sm-6">
                    <div class="deals-contact">
                        <ul>
                            <li>
                                <div class="deals-list">
                                    <div class="contact-icon">
                                        <i class="fa-solid fa-envelope"></i>
                                    </div>
                                    <div class="contact-text">
                                        <p>contacto@saleyvale.com</p>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="deals-list">
                                    <div class="contact-icon">
                                        <i class="fa-solid fa-phone-volume"></i>
                                    </div>
                                    <div class="contact-text">
                                        <p>+52 625 111 8245</p>
                                    </div>
                                </div>
                            </li>
                            <li class="nav-item dropdown px-2">
                                <a class="lang-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                                    <img src="{{ asset('website-assets/img/' . session('website_locale', 'es') . '.png') }}"
                                        alt="{{ session('website_locale', 'es') }}" width="20" class="me-1">
                                    {{ strtoupper(session('website_locale', 'es')) }}
                                </a>
                                <ul class="dropdown-menu">
                                    @foreach (['en' => 'EN', 'es' => 'ES'] as $key => $lang)
                                        @if ($key !== session('website_locale', 'en'))
                                            <li>
                                                <form action="{{ route('website.switchLang') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="locale" value="{{ $key }}">
                                                    <button class="dropdown-item d-flex align-items-center">
                                                        <img src="{{ asset('website-assets/img/' . $key . '.png') }}"
                                                            alt="{{ $lang }}" width="20" class="me-2">
                                                        {{ $lang }}
                                                    </button>
                                                </form>
                                            </li>
                                        @endif
                                    @endforeach
                                </ul>
                            </li>
                        </ul>


                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- ========= Header  ======= -->
    <header id="header">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <nav class="navbar navbar-expand-lg" id="mainNavbar">
                        <div class="container ps-0">
                            <a class="navbar-brand" href="{{ route('website.home') }}"><img
                                    src="{{ asset('website-assets/img/header-logo.png') }}" class="img-fluid"
                                    alt="Header Logo"></a>
                            <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                                data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                                aria-expanded="false" aria-label="Toggle navigation">
                                <span class="navbar-toggler-icon"><i class="fa-solid fa-bars"></i></span>
                            </button>
                            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                                <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
                                    <li class="nav-item"><a class="nav-link" aria-current="page"
                                            href="{{ route('website.home') }}">@lang('website.links.navigation.labels.home')</a></li>
                                    <li class="nav-item"><a class="nav-link"
                                            href="{{ route('website.about') }}">@lang('website.links.navigation.labels.about_us')</a></li>
                                    <li class="nav-item"><a class="nav-link"
                                            href="{{ route('website.downloadApp') }}">@lang('website.links.navigation.labels.download_app')</a>
                                    </li>
                                    <li class="nav-item"><a class="nav-link"
                                            href="{{ route('website.contact') }}">@lang('website.links.navigation.labels.contact_us')</a></li>
                                </ul>
                                <form class="d-flex" role="search">
                                    <div class="social-media">
                                        <ul>
                                            <li><a href="#"><i class="fa-brands fa-facebook-f"></i></a></li>
                                            <li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
                                            <li><a href="#"><i class="fa-brands fa-x-twitter"></i></a></li>
                                            <li><a href="#"><i class="fa-brands fa-linkedin-in"></i></a></li>
                                        </ul>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </header>


    <main>
        @yield('content')
    </main>


    <!-- ========= Footer  ======= -->
    <footer>
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-sm-6">
                    <div class="footer-section">
                        <div class="footer-logo mb-2">
                            <img src="{{ asset('website-assets/img/footer-logo.png') }}" class="img-fluid"
                                alt="Logo" />
                        </div>
                        <div class="social-media">
                            <ul>
                                <li><a href="#"><i class="fa-brands fa-facebook-f"></i></a></li>
                                <li><a href="#"><i class="fa-brands fa-instagram"></i></a></li>
                                <li><a href="#"><i class="fa-brands fa-x-twitter"></i></a></li>
                                <li><a href="#"><i class="fa-brands fa-linkedin-in"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <div class="footer-section">
                        <h2>@lang('website.links.navigation.heading')</h2>
                        <div class="nav-links">
                            <ul>
                                <li><a href="{{ route('website.home') }}">@lang('website.links.navigation.labels.home')</a></li>
                                <li><a href="{{ route('website.about') }}">@lang('website.links.navigation.labels.about_us')</a></li>
                                <li><a href="{{ route('website.downloadApp') }}">@lang('website.links.navigation.labels.download_app')</a></li>
                                <li><a href="{{ route('website.contact') }}">@lang('website.links.navigation.labels.contact_us')</a></li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <div class="footer-section">
                        <h2>@lang('website.links.get_in_touch')</h2>
                        <div class="get-touch-box">
                            <div class="contact-list">
                                <div class="contact-icon">
                                    <i class="fa-solid fa-location-dot"></i>
                                </div>
                                <div class="contact-icon-text">
                                    <p>Chihuahua City</p>
                                </div>
                            </div>
                            <div class="contact-list">
                                <div class="contact-icon">
                                    <i class="fa-solid fa-phone-volume"></i>
                                </div>
                                <div class="contact-icon-text">
                                    <p>+52 625 111 8245</p>
                                </div>
                            </div>
                            <div class="contact-list">
                                <div class="contact-icon">
                                    <i class="fa-solid fa-envelope"></i>
                                </div>
                                <div class="contact-icon-text">
                                    <p>contacto@saleyvale.com</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6">
                    <div class="footer-section">
                        <h2>@lang('website.links.navigation.labels.download_app')</h2>
                        <div class="download-app-link">
                            <ul>
                                <li><a href="https://play.google.com/store/apps/details?id=com.it.saleyvale"><img
                                            src="{{ asset('website-assets/img/playstore-2.png') }}" class="img-fluid"
                                            alt="Playstore"></a></li>
                                <li><a href="https://apps.apple.com/us/app/sale-y-vale/id6754445011"><img
                                            src="{{ asset('website-assets/img/playstore-1.png') }}" class="img-fluid"
                                            alt="Playstore"></a></li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <div class="copyright-top">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-sm-6">
                        <p>Copyright @2025 Sale y Vale @lang('website.all_rights_reserved')</p>
                    </div>
                    <div class="col-lg-6 col-sm-6">
                        <div class="copyright-link">
                            <ul>
                                <li><a href="{{ route('website.termsConditions') }}">@lang('website.links.navigation.labels.terms_conditions')</a></li>
                                <li><a href="{{ route('website.privacyPolicy') }}">@lang('website.links.navigation.labels.privacy_policy')</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>


    <!-- ========= Back to Top ======= -->
    <div class="scroll-top-wrapper ">
        <span class="scroll-top-inner">
            <i class="fa fa-2x fa-arrow-circle-up"></i>
        </span>
    </div>


    <!-- ========= JQuery  ======= -->
    <script src="{{ asset('website-assets/js/jquery.js') }}"></script>

    <!-- ========= Bootstrap  ======= -->
    <script src="{{ asset('website-assets/js/bootstrap.bundle.min.js') }}"></script>

    <!-- ========= Custom  ======= -->
    @yield('scripts')
    <script src="{{ asset('website-assets/js/custom.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-toast-plugin/1.3.2/jquery.toast.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- ========= AOS Animation ======= -->
    <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
    <script>
        AOS.init();
        //translate
        window.translation = {
            sending: "{{ __('website.contact_form.sending') }}",
            message_sent: "{{ __('website.contact_form.message_sent') }}",
            something_wrong: "{{ __('website.contact_form.something_wrong') }}",
            try_again: "{{ __('website.contact_form.try_again') }}",
            server_error: "{{ __('website.contact_form.server_error') }}",
            please_wait: "{{ __('website.contact_form.please_wait') }}"
        }
    </script>

</body>

</html>
