@extends('website.layouts.main')
@section('title')
    @lang('website.links.navigation.labels.home') | Sale Y Vale
@endsection
@section('content')
    <!-- ========= Main Banner ======= -->
    <section id="main-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-5 col-sm-8" data-aos="fade-up" data-aos-duration="2000">
                    <div class="main-banner-text">
                        <h1>@lang('website.home.slider_heading')</h1>
                        <h4>@lang('website.home.sub_heading')</h4>
                        <p>@lang('website.home.description')</p>
                        <ul>
                            <li><a href="https://play.google.com/store/apps/details?id=com.it.saleyvale"><img
                                        src="{{ asset('website-assets/img/playstore-2.png') }}" class="img-fluid"
                                        alt="Playstore"></a></li>
                            <li><a href="https://apps.apple.com/us/app/sale-y-vale/id6754445011"><img
                                        src="{{ asset('website-assets/img/playstore-1.png') }}" class="img-fluid"
                                        alt="Playstore"></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- ========= About Us ======= -->
    <section id="aboutus">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-sm-6" data-aos="fade-up" data-aos-duration="2000">
                    <div class="aboutus-img">
                        <img src="{{ asset('website-assets/img/aboutus.png') }}" class="img-fluid" alt="About Us">
                    </div>
                </div>
                <div class="col-lg-6 col-sm-6" data-aos="fade-up" data-aos-duration="2000">
                    <div class="aboutus-text">
                        <span>@lang('website.about_us.sub_title')</span>
                        <h2>@lang('website.about_us.title')</h2>
                        <p>@lang('website.about_us.description1')</p>
                        <p>@lang('website.about_us.description2')</p>

                        <div class="read-more-btn">
                            <a href="{{ route('website.about') }}" class="btn btn-primary">@lang('website.about_us.read_more')</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- ========= How it Works ======= -->
    <section id="works-div">
        <div class="container">
            <div class="row">
                <div class="col-lg-12" data-aos="fade-up" data-aos-duration="2000">
                    <div class="section-title">
                        <span>@lang('website.app_download.sub_title')</span>
                        <h2>@lang('website.app_download.title')</h2>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-lg-4 col-sm-6 mb-2" data-aos="fade-up" data-aos-duration="2000">
                    <div class="steps-box">
                        <div class="steps-info">
                            <div class="list-steps-img">
                                <img src="{{ asset('website-assets/img/icon-1.png') }}" class="img-fluid" alt="steps">
                            </div>
                            <div class="lists-text">
                                <h3>@lang('website.app_download.grid1.title')</h3>
                                <p>@lang('website.app_download.grid1.description')</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6 mb-2" data-aos="fade-up" data-aos-duration="2000">
                    <div class="steps-box">
                        <div class="steps-info">
                            <div class="list-steps-img">
                                <img src="{{ asset('website-assets/img/icon-2.png') }}" class="img-fluid" alt="steps">
                            </div>
                            <div class="lists-text">
                                <h3>@lang('website.app_download.grid2.title')</h3>
                                <p>@lang('website.app_download.grid2.description')</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6 mb-2" data-aos="fade-up" data-aos-duration="2000">
                    <div class="steps-box">
                        <div class="steps-info">
                            <div class="list-steps-img">
                                <img src="{{ asset('website-assets/img/icon-3.png') }}" class="img-fluid" alt="steps">
                            </div>
                            <div class="lists-text">
                                <h3>@lang('website.app_download.grid3.title')</h3>
                                <p>@lang('website.app_download.grid3.description')</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- ========= App Download  ======= -->
    <section id="app-download">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-sm-6" data-aos="fade-up" data-aos-duration="2000">
                    <div class="app-screens">
                        <img src="{{ asset('website-assets/img/screenshots.png') }}" class="img-fluid" alt="appscreens">
                    </div>
                </div>
                <div class="col-lg-6 col-sm-6" data-aos="fade-up" data-aos-duration="2000">
                    <div class="app-screen-text">
                        <h2>@lang('website.app_promo.title')</h2>
                        <p>@lang('website.app_promo.description')</p>
                        <ul>
                            <li><a href="https://play.google.com/store/apps/details?id=com.it.saleyvale"><img
                                        src="{{ asset('website-assets/img/playstore-2.png') }}" class="img-fluid"
                                        alt="Playstore"></a></li>
                            <li><a href="https://apps.apple.com/us/app/sale-y-vale/id6754445011"><img
                                        src="{{ asset('website-assets/img/playstore-1.png') }}" class="img-fluid"
                                        alt="Playstore"></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>



    <!-- ========= FAQ Section  ======= -->
    <section id="faq-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-12" data-aos="fade-up" data-aos-duration="2000">
                    <div class="section-title">
                        <span>@lang('website.faq.subtitle')</span>
                        <h2>@lang('website.faq.title')</h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12" data-aos="fade-up" data-aos-duration="2000">
                    <div class="faq-list">
                        <div class="accordion" id="accordionExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        @lang('website.faq.faqs1.question')
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse show"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>@lang('website.faq.faqs1.answer')</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        @lang('website.faq.faqs2.question')
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>
                                        <p>@lang('website.faq.faqs2.answer')</p>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseThree" aria-expanded="false"
                                        aria-controls="collapseThree">
                                        @lang('website.faq.faqs3.question')
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>@lang('website.faq.faqs3.answer')</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapsefour" aria-expanded="false"
                                        aria-controls="collapsefour">
                                        @lang('website.faq.faqs4.question')
                                    </button>
                                </h2>
                                <div id="collapsefour" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>@lang('website.faq.faqs4.answer')</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapsefive" aria-expanded="false"
                                        aria-controls="collapsefive">
                                        @lang('website.faq.faqs5.question')
                                    </button>
                                </h2>
                                <div id="collapsefive" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>@lang('website.faq.faqs5.answer')</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapsesix" aria-expanded="false" aria-controls="collapsesix">
                                        @lang('website.faq.faqs6.question')
                                    </button>
                                </h2>
                                <div id="collapsesix" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>@lang('website.faq.faqs6.answer')</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
