<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification</title>
    <style>
        body {
            font-family: Aarial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            color: #333333;
        }

        .container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            text-align: center;
            padding-bottom: 20px;
        }

        .header img {
            width: 100px;
        }

        .header h1 {
            font-size: 24px;
            color: #333333;
            margin: 0;
        }

        .content {
            text-align: center;
        }

        .content p {
            font-size: 16px;
            line-height: 1.5;
            color: #666666;
        }

        .otp {
            font-size: 32px;
            font-weight: bold;
            letter-spacing: 5px;
            margin: 20px 0;
            color: #333333;
        }

        .footer {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid #dddddd;
            color: #888888;
            font-size: 12px;
        }

        .footer a {
            color: #0A1C3D !important;

            text-decoration: none;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <img src="{{ url(LOGO_IMG_PATH) }}" alt="Company Logo">
            <h1>Email Verification</h1>
        </div>
        <div class="content">
            <p>Thank you for registering with us! Please use the following One-Time Password (OTP) to verify your email
                address:</p>
            <div class="otp">{{ $result['email_otp'] }}</div>
            <p>This OTP is valid for the next 10 minutes. If you didn't request this, please ignore this email.</p>
        </div>
        <div class="footer">
            {{-- <p>If you have any questions, feel free to <a href="{{ route('web.contactUs') }}">contact us</a>.</p> --}}
            <p>&copy; {{ date('Y') }} Sale y vale. All rights reserved.</p>
        </div>
    </div>
</body>

</html>
