@extends('admin.layouts.main')
@section('title', 'Users List')
@section('content')
    <div class="content-wrapper">

        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row">
                <div class="col-12">
                    <!-- Hoverable Table rows -->
                    <div class="card px-4">

                        @if (session('success'))
                            <div class="alert alert-success pt-2">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger pt-2">
                                {{ session('error') }}
                            </div>
                        @endif



                        <div class="mt-5 d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark">@lang('message.users_list')</h3>
                            <a href="{{ route('admin.user.create') }}" class="btn btn-primary"><i
                                    class='bx bx-plus-circle'></i>@lang('message.create_user')</a>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div id="pagination-table">
                                    <table class="dataTable dt-responsive table table-hover display align-middle mb-0">
                                        <thead>
                                            <tr>
                                                <th>
                                                    @lang('message.customer_list_register')
                                                    </span></th>
                                                <th>
                                                    @lang('message.name')
                                                    </span></th>

                                                <th>
                                                    @lang('message.assigned_role')
                                                    </span></th>
                                                <th>
                                                    @lang('message.customer_list_email')
                                                    </span></th>
                                                <th>
                                                    @lang('message.customer_list_mobile')
                                                    </span></th>
                                                <th>
                                                    @lang('message.status')
                                                    </span></th>
                                                <th>@lang('message.actions')</span></th>
                                            </tr>
                                        </thead>
                                        @if (isset($admins) && count($admins) > 0)
                                            <tbody class="table-border-bottom-0">

                                                @foreach ($admins as $user)
                                                    <tr>

                                                        <td class="text-capitalize">
                                                            {{ dateFormat($user->created_at, DISPLAY_DATE) }}</td>
                                                        <td class="text-capitalize">{{ $user->name }}</td>
                                                        <td class="text-capitalize">
                                                            {{ $user->roles->pluck('name')->implode(', ') }}

                                                        </td>
                                                        <td class="">{{ $user->email }}</td>
                                                        <td class="text-capitalize">

                                                            {{ $user->dial_code }}
                                                            {{ $user->mobile_number }}
                                                        </td>
                                                        <td class="text-capitalize">
                                                            {!! statusText($user->status) !!}
                                                        </td>
                                                        <td>



                                                            <div class="d-flex">


                                                                <a class="btn-role"
                                                                    href="{{ route('admin.user.edit', $user->id) }}">
                                                                    <i class="bx bx-edit"></i></a>


                                                                <button class="delete-btn btn-role"
                                                                    data-url="{{ route('admin.user.destroy', $user->id) }}"
                                                                    data-id="{{ $user->id }}"><i
                                                                        class="bx bx-trash me-1"></i>
                                                                </button>


                                                            </div>






                                                        </td>
                                                    </tr>



                                            </tbody>
                                        @endforeach
                                        @endif
                                    </table>

                                </div>
                            </div>
                        </div>

                    </div>
                    <!--/ Hoverable Table rows -->
                </div>
            </div>

        </div>
        <!-- / Content -->
    @endsection
