@extends('admin.layouts.main')
@section('title', 'Edit User')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="row m-3">
            <div class="col-lg-12">
                <div class="card">


                    <div class="card-body">
                        <div class="mt-2 d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark">@lang('message.edit_user')</h3>
                            <a href="{{ route('admin.user.index') }}" class="btn btn-primary">
                                <i class='bx bx-list-ul'></i>
                                @lang('message.users_list')</a>
                        </div>
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form action="{{ route('admin.user.update', $admin->id) }}" class="ajaxSubmit"
                                    id="ajaxSubmit2" enctype="multipart/form-data" method="POST">
                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mb-3 justify-content-end ">


                                        <div class="col-12">
                                            @if ($roles->isNotEmpty())
                                                <div class="row my-3">
                                                    <label for="email"
                                                        class="col-md-2 text-sm-end  col-form-label">@lang('message.select_role')</label>
                                                    <div class="col-md-10">
                                                        <select class="form-select" name="role" id="role">
                                                            <option value="">@lang('message.select_role')</option>
                                                            @foreach ($roles as $role)
                                                                {{-- <option value="{{ $role->name }}"
                                                                    {{ old('role', $adminRole) == $role->id ? 'selected' : '' }}>
                                                                    {{ $role->name }}
                                                                </option> --}}
                                                                <option value="{{ $role->name }}"
                                                                    {{ old('role', $adminRole->contains($role->id)) ? 'selected' : '' }}>
                                                                    {{ $role->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>


                                                    </div>
                                                </div>
                                            @endif
                                            <div class="row my-3">
                                                <label for="Name" class="col-md-2 text-sm-end col-form-label">
                                                    @lang('message.name')</label>
                                                <div class="col-md-10">
                                                    <input type="text"
                                                        class="form-control text-capitalize @error('name') is-invalid @enderror"
                                                        id="name" name="name"
                                                        value="{{ old('email', $admin->name) }}">
                                                    @error('name')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="email"
                                                    class="col-md-2 text-sm-end  col-form-label">@lang('message.customer_list_email')</label>
                                                <div class="col-md-10">
                                                    <input type="text" name="email"
                                                        class="form-control @error('email') is-invalid @enderror"
                                                        id="email" value="{{ old('email', $admin->email) }}">
                                                    @error('email')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="Name"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.password')</label>
                                                <div class="col-md-10">
                                                    <input type="password" class="form-control text-capitalize "
                                                        id="password" name="password" value="{{ old('password') }}">

                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="Name"
                                                    class="col-md-2 text-sm-end col-form-label">@lang('message.confirm_password')</label>
                                                <div class="col-md-10">
                                                    <input type="password" class="form-control text-capitalize "
                                                        id="password_confirmation" name="password_confirmation"
                                                        value="{{ old('password_confirmation') }}">

                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="mobile"
                                                    class="col-md-2 text-sm-end  col-form-label">@lang('message.customer_list_mobile')</label>
                                                <div class="col-md-10">
                                                    <input type="tel" name="mobile_number" id="phone"
                                                        class="form-control  @error('email') is-invalid @enderror"
                                                        id="mobile"
                                                        value="{{ old('mobile_number', $admin->mobile_number) }}">
                                                    @error('mobile_number')
                                                        <p class="invalid-feedback">{{ $message }}</p>
                                                    @enderror
                                                    <input type="hidden" name="dial_code" id="dial_code"
                                                        value="{{ $admin->dial_code }}">
                                                    <input type="hidden" name="dial_code_iso" id="dial_code_iso"
                                                        value="{{ $admin->dial_code_iso }}">
                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="image"
                                                    class="col-md-2 text-sm-end  col-form-label">@lang('message.image')</label>
                                                <div class="col-md-10">
                                                    <input type="file" name="image" class="form-control"
                                                        id="image">
                                                    <div class="image mt-4">
                                                        <img width='100'
                                                            src="{{ asset('uploads/admin/' . $admin->image) }}"
                                                            class="img-fluid" alt="default image">

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row my-3">
                                                <label for="status"
                                                    class="col-md-2 text-sm-end  col-form-label">@lang('message.image')</label>
                                                <div class="col-md-10">
                                                    <select class="form-select @error('status') is-invalid @enderror"
                                                        name="status">
                                                        <option value="active"
                                                            {{ $admin->status == 'active' ? 'selected' : '' }}>
                                                            Active
                                                        </option>
                                                        <option value="inactive"
                                                            {{ $admin->status == 'inactive' ? 'selected' : '' }}>
                                                            Inactive</option>

                                                    </select>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="offset-md-2">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bx bx-check"></i> @lang('message.update_user')
                                        </button>
                                    </div>
                            </div>

                            {{-- display roles --}}







                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->



@endsection
@section('top_scripts')
    <script>
        let initial_country = '{{ strtolower($admin->dial_code_iso) }}';
    </script>
@endsection
