@extends('admin.layouts.main')
@section('title', 'Dashboard')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="row m-3">
            <div class="col-lg-8">
                <div class="card">
                    <h5 class="card-header text-uppercase text-dark border-bottom">
                        @lang('message.deal_settings')
                    </h5>

                    <div class="card-body">

                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form action="{{ route('admin.setting.update') }}" class="ajaxSubmit" id="ajaxSubmit2"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mb-5 justify-content-end ">
                                        <div class="col-md-3">
                                            <label for="" class="form-label">@lang('message.transfer_fees')</label>
                                        </div>

                                        <div class="col-md-9">
                                            <div class="input-group input-group-merge">
                                                <input class="form-control @error('transfer_fees') is-invalid @enderror"
                                                    type="text" name="transfer_fees"
                                                    value="{{ old('transfer_fees', $result) }}" value="{{ $result }}"
                                                    id="transfer_fees">
                                                <span class="input-group-text">%</span>

                                            </div>

                                        </div>
                                    </div>

                                    <div class="row mt-4">
                                        <div class="col-md-9 offset-md-3">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> @lang('message.save_details')
                                            </button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->

    @endsection
