@extends('admin.layouts.main')
@section('title', 'Edit Customer')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->

        <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Basic Layout -->
                <div class="row">
                    <div class="col-xl">
                        <div class="card mb-4">
                            <div class="card-header border-b d-flex justify-content-between align-items-center">
                                <h5 class="mb-0 text-dark text-uppercase">@lang('message.help')</h5>

                            </div>

                            <div class="card-body pt-5">
                                <form action="{{ route('admin.setting.help.update') }}" class="ajaxSubmit" id="ajaxSubmit"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">

                                    <div class="row page-management-align">
                                        <div class="col-md-3 col-sm-12 text-right pt-2">
                                            <div class="mb-3">
                                                <label class="form-label"
                                                    for="basic-default-fullname">@lang('message.help_en')</label>
                                            </div>
                                        </div>
                                        <div class="col-md-9 col-sm-12">
                                            <div class="mb-3">
                                                <textarea name="help_en" class="help_en" id="help_en" cols="30" rows="10">{!! $result->help_en ?? '' !!}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row page-management-align">
                                        <div class="col-md-3 col-sm-12 text-right pt-2">
                                            <div class="mb-3">
                                                <label class="form-label"
                                                    for="basic-default-fullname">@lang('message.help_es')</label>
                                            </div>
                                        </div>
                                        <div class="col-md-9 col-sm-12">
                                            <div class="mb-3">
                                                <textarea name="help_es" class="help_es" id="help_es" cols="30" rows="10">{!! $result->help_es ?? '' !!}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="submit-btn-outer my-3 offset-md-3">
                                        <button type="submit" class="btn btn-primary">@lang('message.update_details')</button>
                                    </div>

                                </form>


                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- / Content -->




    @endsection

    @section('scripts')
        <script>
            CKEDITOR.replace('help_en');
            CKEDITOR.replace('help_es');
            // CKEDITOR.replace('help_no');
        </script>

    @endsection
