@extends('admin.layouts.main')
@section('title', 'Dashboard')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="row m-3">
            <div class="col-lg-8">
                <div class="card">
                    <h5 class="card-header text-uppercase text-dark border-bottom">
                        @lang('message.bank_details')
                    </h5>

                    <div class="card-body">

                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form action="{{ route('admin.setting.bankDetails.update') }}" class="ajaxSubmit"
                                    id="ajaxSubmit2" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="_method" value="PUT">
                                    <div class="row mb-5 justify-content-end ">
                                        <div class="col-md-3">
                                            <label for="" class="form-label">@lang('message.bank')</label>
                                        </div>

                                        <div class="col-md-9">

                                            {{-- <input class="form-control @error('transfer_fees') is-invalid @enderror"
                                                    type="text" name="transfer_fees"
                                                    value="{{ old('transfer_fees', $result) }}" value="{{ $result }}"
                                                    id="transfer_fees"> --}}

                                            <input class="form-control @error('bank') is-invalid @enderror" type="text"
                                                name="bank" value="{{ old('bank', $bank) }}" value="{{ $bank }}"
                                                id="bank">


                                        </div>
                                    </div>
                                    <div class="row mb-5 justify-content-end ">
                                        <div class="col-md-3">
                                            <label for="" class="form-label">@lang('message.card_number')</label>
                                        </div>

                                        <div class="col-md-9">

                                            {{-- <input class="form-control @error('transfer_fees') is-invalid @enderror"
                                                    type="text" name="transfer_fees"
                                                    value="{{ old('transfer_fees', $result) }}" value="{{ $result }}"
                                                    id="transfer_fees"> --}}

                                            <input class="form-control @error('card_number') is-invalid @enderror"
                                                type="text" name="card_number"
                                                value="{{ formatCardNumber($card_number) }}" id="card_number">


                                        </div>
                                    </div>

                                    <div class="row mt-4">
                                        <div class="col-md-9 offset-md-3">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> @lang('message.save_details')
                                            </button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->

    @endsection
