@extends('admin.layouts.main')
@section('title', 'Dashboard')
@section('content')
    <div class="content-wrapper">

        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row ">
                <div class="col-lg-8 col-md-10">
                    <!-- Hoverable Table rows -->
                    <div class="card px-4 pt-4">

                        @if (session('success'))
                            <div class="alert alert-success pt-2">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger pt-2">
                                {{ session('error') }}
                            </div>
                        @endif



                        <div class="mt-5 d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark">@lang('message.role_list')</h3>
                            <a href="{{ route('admin.role.create') }}" class="btn btn-primary"><i
                                    class='bx bx-plus-circle'></i> @lang('message.create_role')</a>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div id="pagination-table">
                                    <table class=" dt-responsive table table-hover display align-middle mb-0">
                                        <thead>
                                            <tr>

                                                <th><span class="sortable" data-sort="id" data-order="asc">
                                                        @lang('message.name') <i id="sort-icon-id" class="bx bx-sort"></i>
                                                    </span></th>

                                                <th> @lang('message.actions')</span></th>
                                            </tr>
                                        </thead>
                                        @if (isset($roles) && count($roles) > 0)
                                            <tbody class="table-border-bottom-0">

                                                @foreach ($roles as $role)
                                                    <tr>

                                                        <td class="text-capitalize">{{ $role->name }}</td>
                                                        <td>



                                                            <div class="d-flex">


                                                                <a class="btn-role"
                                                                    href="{{ route('admin.role.edit', $role->id) }}">
                                                                    <i class="bx bx-edit"></i></a>


                                                                <button class="delete-btn btn-role"
                                                                    data-url="{{ route('admin.role.destroy', $role->id) }}"
                                                                    data-id="{{ $role->id }}"><i
                                                                        class="bx bx-trash me-1"></i>
                                                                </button>


                                                            </div>






                                                        </td>
                                                    </tr>



                                            </tbody>
                                        @endforeach
                                    @else
                                        <tbody>
                                            <tr>
                                                <td colspan ="3" class="text-danger">No Roles created</td>
                                            </tr>
                                        </tbody>
                                        @endif
                                    </table>

                                </div>
                            </div>
                        </div>

                    </div>
                    <!--/ Hoverable Table rows -->
                </div>
            </div>

        </div>
        <!-- / Content -->
    @endsection
