@extends('admin.layouts.main')
@section('title', 'Create Roles')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="col-lg-12">
                <div class="card">


                    <div class="card-body">
                        <div class="mt-2 d-flex justify-content-between align-items-center pb-2">
                            <h3 class=" text-dark">@lang('message.create_role')</h3>
                            <a href="{{ route('admin.role.index') }}" class="btn btn-primary">
                                <i class='bx bx-list-ul'></i>
                                @lang('message.role_list')</a>
                        </div>
                        <div class="row mt-4">
                            <div class="col-lg-12">
                                <form action="{{ route('admin.role.store') }}" class="ajaxSubmit" id="ajaxSubmit2"
                                    enctype="multipart/form-data" method="POST">
                                    @csrf

                                    <div class="row mb-3 justify-content-end ">
                                        <div class="col-md-1  mt-1">
                                            <label for="" class="form-label">@lang('message.title')</label>
                                        </div>

                                        <div class="col-md-11">

                                            <input class="form-control " type="text" name="name" value=""
                                                id="name">

                                        </div>
                                    </div>

                                    {{-- display permissions --}}
                                    <div id="permissions-wrap" class="container">
                                        <h6 class="txt-blck">@lang('message.permissions')</h6>
                                        <hr>
                                        <div class="row mt-2" id="permissions">
                                            @if (!empty($translatedPermissions))
                                                @foreach ($translatedPermissions as $module => $modulePermissions)
                                                    <div class="col-2  mt-4 ">
                                                        <label
                                                            class="text-dark text-capitalize me-3">{{ $module }}:</label>
                                                    </div>
                                                    <div class="row ">

                                                        @foreach ($modulePermissions as $permission)
                                                            <div class="col-lg-3 col-md-6 col-sm-12 pt-2">
                                                                <input class="form-check-input" type="checkbox"
                                                                    name="permissions[]" value="{{ $permission->value }}"
                                                                    id="perm_{{ $permission->id }}">
                                                                <label class="form-check-label text-capitalize"
                                                                    for="perm_{{ $permission->id }}">
                                                                    {{ $permission->name }}
                                                                </label>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>


                                    <div class="row mt-4 mb-2">
                                        <div class="">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="bx bx-check"></i> @lang('message.save_role')
                                            </button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->



    @endsection
    @section('scripts')
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const viewDetail = document.querySelector("#perm_70");
                const ongoingList = document.querySelector("#perm_21");
                if (viewDetail && ongoingList) {
                    viewDetail.addEventListener('change', function() {
                        if (this.checked) {
                            ongoingList.checked = true;
                        }
                    });
                }
            });
        </script>
    @endsection
